/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class FilteringHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getWorld();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        if (player.m_6144_() || player.m_5833_()) {
            return;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        BlockHitResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(ray.m_82434_())) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(ray.m_82434_());
        }
        if (!behaviour.testHit(ray.m_82450_())) {
            return;
        }
        ItemStack toApply = player.m_21120_(hand).m_41777_();
        if (AllItems.WRENCH.isIn(toApply)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(toApply)) {
            return;
        }
        if (event.getSide() != LogicalSide.CLIENT) {
            if (!player.m_7500_()) {
                if (toApply.m_41720_() instanceof FilterItem) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (behaviour.getFilter().m_41720_() instanceof FilterItem) {
                    player.m_150109_().m_150079_(behaviour.getFilter());
                }
            }
            if (toApply.m_41720_() instanceof FilterItem) {
                toApply.m_41764_(1);
            }
            behaviour.setFilter(toApply);
        } else {
            ItemStack filter = behaviour.getFilter();
            String feedback = "apply_click_again";
            if (toApply.m_41720_() instanceof FilterItem || !behaviour.isCountVisible()) {
                feedback = "apply";
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)toApply, (ItemStack)filter)) {
                feedback = "apply_count";
            }
            String translationKey = world.m_8055_(pos).m_60734_().m_7705_();
            TranslatableComponent formattedText = new TranslatableComponent(translationKey);
            player.m_5661_((Component)Lang.createTranslationTextComponent("logistics.filter." + feedback, formattedText).m_130940_(ChatFormatting.WHITE), true);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        BlockPos blockPos = result.m_82425_();
        FilteringBehaviour filtering = TileEntityBehaviour.get((BlockGetter)world, blockPos, FilteringBehaviour.TYPE);
        if (filtering == null) {
            return false;
        }
        if (mc.f_91074_.m_6144_()) {
            return false;
        }
        if (!mc.f_91074_.m_36326_()) {
            return false;
        }
        if (!filtering.isCountVisible()) {
            return false;
        }
        if (!filtering.isActive()) {
            return false;
        }
        if (filtering.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)filtering.slotPositioning).fromSide(result.m_82434_());
        }
        if (!filtering.testHit(objectMouseOver.m_82450_())) {
            return false;
        }
        ItemStack filterItem = filtering.getFilter();
        filtering.ticksUntilScrollPacket = 10;
        int maxAmount = filterItem.m_41720_() instanceof FilterItem ? 64 : filterItem.m_41741_();
        int prev = filtering.scrollableValue;
        filtering.scrollableValue = (int)Mth.m_14008_((double)((double)filtering.scrollableValue + delta * (double)(AllKeys.ctrlDown() ? 16 : 1)), (double)0.0, (double)maxAmount);
        if (prev != filtering.scrollableValue) {
            float pitch = (float)filtering.scrollableValue / (float)maxAmount;
            pitch = Mth.m_14179_((float)pitch, (float)1.5f, (float)2.0f);
            AllSoundEvents.SCROLL_VALUE.play((Level)world, (Player)mc.f_91074_, (Vec3i)blockPos, 1.0f, pitch);
        }
        return true;
    }
}

