/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class CustomBlockModels {
    private List<Pair<Supplier<? extends Block>, NonNullFunction<BakedModel, ? extends BakedModel>>> registered = new ArrayList<Pair<Supplier<? extends Block>, NonNullFunction<BakedModel, ? extends BakedModel>>>();
    private Map<Block, NonNullFunction<BakedModel, ? extends BakedModel>> customModels = new IdentityHashMap<Block, NonNullFunction<BakedModel, ? extends BakedModel>>();

    public void register(Supplier<? extends Block> entry, NonNullFunction<BakedModel, ? extends BakedModel> behaviour) {
        this.registered.add((Pair<Supplier<? extends Block>, NonNullFunction<BakedModel, ? extends BakedModel>>)Pair.of(entry, behaviour));
    }

    public void forEach(NonNullBiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>> consumer) {
        this.loadEntriesIfMissing();
        this.customModels.forEach(consumer);
    }

    private void loadEntriesIfMissing() {
        if (this.customModels.isEmpty()) {
            this.loadEntries();
        }
    }

    private void loadEntries() {
        this.customModels.clear();
        this.registered.forEach((? super T p) -> {
            Block key = (Block)((Supplier)p.getKey()).get();
            NonNullFunction<BakedModel, ? extends BakedModel> existingModel = this.customModels.get(key);
            if (existingModel != null) {
                this.customModels.put(key, ((NonNullFunction)p.getValue()).andThen(existingModel));
                return;
            }
            this.customModels.put(key, (NonNullFunction)p.getValue());
        });
    }
}

