/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ConnectedTextureBehaviour {
    public abstract CTSpriteShiftEntry get(BlockState var1, Direction var2);

    protected boolean reverseUVs(BlockState state, Direction face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    public boolean buildContextForOccludedDirections() {
        return false;
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face, Direction primaryOffset, Direction secondaryOffset) {
        return this.connectsTo(state, other, reader, pos, otherPos, face);
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        return !this.isBeingBlocked(state, reader, pos, otherPos, face) && state.m_60734_() == other.m_60734_();
    }

    protected boolean isBeingBlocked(BlockState state, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        BlockPos blockingPos = otherPos.m_142300_(face);
        return face.m_122434_().m_7863_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) == face.m_122434_().m_7863_(otherPos.m_123341_(), otherPos.m_123342_(), otherPos.m_123343_()) && this.connectsTo(state, reader.m_8055_(blockingPos), reader, pos, blockingPos, face);
    }

    public CTContext buildContext(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        CTContext context = new CTContext();
        CTSpriteShiftEntry textureEntry = this.get(state, face);
        if (textureEntry == null) {
            return context;
        }
        boolean positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
        Direction h = this.getRightDirection(reader, pos, state, face);
        Direction v = this.getUpDirection(reader, pos, state, face);
        Direction direction = h = positive ? h.m_122424_() : h;
        if (face == Direction.DOWN) {
            v = v.m_122424_();
            h = h.m_122424_();
        }
        Direction horizontal = h;
        Direction vertical = v;
        boolean flipH = this.reverseUVsHorizontally(state, face);
        boolean flipV = this.reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;
        CTSpriteShifter.CTType type = textureEntry.getType();
        if (type != CTSpriteShifter.CTType.HORIZONTAL) {
            context.up = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, sv);
            context.down = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, -sv);
        }
        if (type != CTSpriteShifter.CTType.VERTICAL) {
            context.left = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, 0);
            context.right = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, 0);
        }
        if (type == CTSpriteShifter.CTType.OMNIDIRECTIONAL) {
            context.topLeft = context.up && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, sv);
            context.topRight = context.up && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, sv);
            context.bottomLeft = context.down && context.left && this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, -sv);
            context.bottomRight = context.down && context.right && this.testConnection(reader, pos, state, face, horizontal, vertical, sh, -sv);
        }
        return context;
    }

    protected Direction getUpDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis.m_122479_() ? Direction.UP : Direction.NORTH;
    }

    protected Direction getRightDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
        Direction.Axis axis = face.m_122434_();
        return axis == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
    }

    private boolean testConnection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face, Direction horizontal, Direction vertical, int sh, int sv) {
        BlockPos p = pos.m_5484_(horizontal, sh).m_5484_(vertical, sv);
        boolean test = this.connectsTo(state, reader.m_8055_(p), reader, pos, p, face, sh == 0 ? null : (sh == -1 ? horizontal.m_122424_() : horizontal), sv == 0 ? null : (sv == -1 ? vertical.m_122424_() : vertical));
        return test;
    }

    public class CTContext {
        boolean up;
        boolean down;
        boolean left;
        boolean right;
        boolean topLeft;
        boolean topRight;
        boolean bottomLeft;
        boolean bottomRight;
    }
}

