/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.chute.ChuteShapes;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractChuteBlock
extends Block
implements IWrenchable,
ITE<ChuteTileEntity> {
    public AbstractChuteBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new ReducedDestroyEffects());
    }

    public static boolean isChute(BlockState state) {
        return state.m_60734_() instanceof AbstractChuteBlock;
    }

    public static boolean isOpenChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.m_60734_()).isOpen(state);
    }

    public static boolean isTransparentChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.m_60734_()).isTransparent(state);
    }

    @Nullable
    public static Direction getChuteFacing(BlockState state) {
        return !AbstractChuteBlock.isChute(state) ? null : ((AbstractChuteBlock)state.m_60734_()).getFacing(state);
    }

    public Direction getFacing(BlockState state) {
        return Direction.DOWN;
    }

    public boolean isOpen(BlockState state) {
        return true;
    }

    public boolean isTransparent(BlockState state) {
        return false;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.f_19853_.f_46443_) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        DirectBeltInputBehaviour input = TileEntityBehaviour.get((BlockGetter)entityIn.f_19853_, new BlockPos(entityIn.m_20182_().m_82520_(0.0, 0.5, 0.0)).m_7495_(), DirectBeltInputBehaviour.TYPE);
        if (input == null) {
            return;
        }
        if (!input.canInsertFromSide(Direction.UP)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        ItemStack toInsert = itemEntity.m_32055_();
        ItemStack remainder = input.handleInsertion(toInsert, Direction.UP, false);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
        if (remainder.m_41613_() < toInsert.m_41613_()) {
            itemEntity.m_32045_(remainder);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        this.withTileEntityDo((BlockGetter)world, pos, ChuteTileEntity::onAdded);
        if (p_220082_5_) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(BlockState state, Level world, BlockPos pos) {
        BlockState updated;
        BlockState stateToUpdate;
        if (!AbstractChuteBlock.isChute(state)) {
            return;
        }
        AbstractChuteBlock block = (AbstractChuteBlock)state.m_60734_();
        Direction facing = block.getFacing(state);
        BlockPos toUpdate = pos.m_7495_();
        if (facing.m_122434_().m_122479_()) {
            toUpdate = toUpdate.m_142300_(facing.m_122424_());
        }
        if ((stateToUpdate = world.m_8055_(toUpdate)) != (updated = this.updateChuteState(stateToUpdate, world.m_8055_(toUpdate.m_7494_()), (BlockGetter)world, toUpdate)) && !world.f_46443_) {
            world.m_46597_(toUpdate, updated);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        boolean differentBlock;
        boolean bl = differentBlock = state.m_60734_() != p_196243_4_.m_60734_();
        if (state.m_155947_() && (differentBlock || !p_196243_4_.m_155947_())) {
            TileEntityBehaviour.destroy((BlockGetter)world, pos, FilteringBehaviour.TYPE);
            this.withTileEntityDo((BlockGetter)world, pos, c -> c.onRemoved(state));
            world.m_46747_(pos);
        }
        if (p_196243_5_ || !differentBlock) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
        for (Direction direction : Iterate.horizontalDirections) {
            BlockState updated;
            BlockPos toUpdate = pos.m_7494_().m_142300_(direction);
            BlockState stateToUpdate = world.m_8055_(toUpdate);
            if (!AbstractChuteBlock.isChute(stateToUpdate) || stateToUpdate == (updated = ((AbstractChuteBlock)stateToUpdate.m_60734_()).updateChuteState(stateToUpdate, world.m_8055_(toUpdate.m_7494_()), (BlockGetter)world, toUpdate)) || world.f_46443_) continue;
            world.m_46597_(toUpdate, updated);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState above, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        if (direction != Direction.UP) {
            return state;
        }
        return this.updateChuteState(state, above, (BlockGetter)world, pos);
    }

    public void m_6861_(BlockState p_220069_1_, Level world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (pos.m_7495_().equals((Object)neighbourPos)) {
            this.withTileEntityDo((BlockGetter)world, pos, ChuteTileEntity::blockBelowChanged);
        } else if (pos.m_7494_().equals((Object)neighbourPos)) {
            this.withTileEntityDo((BlockGetter)world, pos, chute -> {
                chute.capAbove = LazyOptional.empty();
            });
        }
    }

    public abstract BlockState updateChuteState(BlockState var1, BlockState var2, BlockGetter var3, BlockPos var4);

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    @Override
    public Class<ChuteTileEntity> getTileEntityClass() {
        return ChuteTileEntity.class;
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return this.onTileEntityUse((BlockGetter)world, pos, te -> {
            if (te.item.m_41619_()) {
                return InteractionResult.PASS;
            }
            player.m_150109_().m_150079_(te.item);
            te.setItem(ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        });
    }
}

