/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;

public class LitBlazeBurnerBlock
extends Block
implements IWrenchable {
    public static final ToolAction EXTINGUISH_FLAME_ACTION = ToolAction.get((String)Create.asResource("extinguish_flame").toString());
    public static final EnumProperty<FlameType> FLAME_TYPE = EnumProperty.m_61587_((String)"flame_type", FlameType.class);

    public LitBlazeBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FLAME_TYPE, (Comparable)((Object)FlameType.REGULAR)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FLAME_TYPE});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof ShovelItem || heldItem.m_41720_().canPerformAction(heldItem, EXTINGUISH_FLAME_ACTION)) {
            world.m_5594_(player, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 2.0f);
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            world.m_46597_(pos, AllBlocks.BLAZE_BURNER.getDefaultState());
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(FLAME_TYPE) == FlameType.REGULAR && heldItem.m_204117_(ItemTags.f_13154_)) {
            world.m_5594_(player, pos, SoundEvents.f_12396_, SoundSource.BLOCKS, 1.0f, world.f_46441_.nextFloat() * 0.4f + 0.8f);
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            world.m_46597_(pos, (BlockState)this.m_49966_().m_61124_(FLAME_TYPE, (Comparable)((Object)FlameType.SOUL)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).m_5940_(state, reader, pos, context);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return AllItems.EMPTY_BLAZE_BURNER.asStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        world.m_6485_((ParticleOptions)ParticleTypes.f_123755_, true, (double)pos.m_123341_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + random.nextDouble() + random.nextDouble(), (double)pos.m_123343_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (random.nextInt(10) == 0) {
            world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.25f + random.nextFloat() * 0.25f, random.nextFloat() * 0.7f + 0.6f, false);
        }
        if (state.m_61143_(FLAME_TYPE) == FlameType.SOUL) {
            if (random.nextInt(8) == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)((float)pos.m_123341_() + 0.5f) + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)((float)pos.m_123342_() + 0.3f) + random.nextDouble() / 2.0, (double)((float)pos.m_123343_() + 0.5f) + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() * 0.04 + 0.04, 0.0);
            }
            return;
        }
        if (random.nextInt(5) == 0) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
            }
        }
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return state.m_61143_(FLAME_TYPE) == FlameType.REGULAR ? 1 : 2;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).m_5939_(state, reader, pos, context);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static int getLight(BlockState state) {
        if (state.m_61143_(FLAME_TYPE) == FlameType.SOUL) {
            return 9;
        }
        return 12;
    }

    public static enum FlameType implements StringRepresentable
    {
        REGULAR,
        SOUL;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

