/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.sync;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class ContraptionFluidPacket
extends SimplePacketBase {
    private int entityId;
    private BlockPos localPos;
    private FluidStack containedFluid;

    public ContraptionFluidPacket(int entityId, BlockPos localPos, FluidStack containedFluid) {
        this.entityId = entityId;
        this.localPos = localPos;
        this.containedFluid = containedFluid;
    }

    public ContraptionFluidPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.localPos = buffer.m_130135_();
        this.containedFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.m_130064_(this.localPos);
        this.containedFluid.writeToPacket(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            contraptionEntity.getContraption().updateContainedFluid(this.localPos, this.containedFluid);
        });
        context.get().setPacketHandled(true);
    }
}

