/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class PortableStorageInterfaceTileEntity
extends SmartTileEntity {
    protected int transferTimer = 0;
    protected float distance;
    protected LerpedFloat connectionAnimation = LerpedFloat.linear().startWithValue(0.0);
    protected boolean powered = false;
    protected Entity connectedEntity;

    public PortableStorageInterfaceTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        this.distance = distance;
        this.connectedEntity = contraption.entity;
        this.startConnecting();
        this.notifyUpdate();
    }

    protected void stopTransferring() {
        this.connectedEntity = null;
    }

    public boolean canTransfer() {
        if (this.connectedEntity != null && !this.connectedEntity.m_6084_()) {
            this.stopTransferring();
        }
        return this.connectedEntity != null && this.isConnected();
    }

    protected abstract void invalidateCapability();

    @Override
    public void tick() {
        boolean isConnected;
        super.tick();
        boolean wasConnected = this.isConnected();
        int timeUnit = this.getTransferTimeout() / 2;
        if (!(this.transferTimer <= 0 || this.isVirtual() && this.transferTimer == timeUnit)) {
            --this.transferTimer;
            if (this.transferTimer == 0 || this.powered) {
                this.stopTransferring();
            }
        }
        if (wasConnected != (isConnected = this.isConnected()) && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
        float progress = 0.0f;
        if (isConnected) {
            progress = 1.0f;
        } else if (this.transferTimer >= timeUnit * 3) {
            progress = Mth.m_14179_((float)((float)(this.transferTimer - timeUnit * 3) / (float)timeUnit), (float)1.0f, (float)0.0f);
        } else if (this.transferTimer < timeUnit) {
            progress = Mth.m_14179_((float)((float)this.transferTimer / (float)timeUnit), (float)0.0f, (float)1.0f);
        }
        this.connectionAnimation.setValue(progress);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.invalidateCapability();
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.transferTimer = compound.m_128451_("Timer");
        this.distance = compound.m_128457_("Distance");
        this.powered = compound.m_128471_("Powered");
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.transferTimer);
        compound.m_128350_("Distance", this.distance);
        compound.m_128379_("Powered", this.powered);
    }

    public void neighbourChanged() {
        boolean isBlockPowered = this.f_58857_.m_46753_(this.f_58858_);
        if (isBlockPowered == this.powered) {
            return;
        }
        this.powered = isBlockPowered;
        this.sendData();
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public boolean isTransferring() {
        return this.transferTimer != 0;
    }

    boolean isConnected() {
        int timeUnit = this.getTransferTimeout() / 2;
        return this.transferTimer >= timeUnit && this.transferTimer <= timeUnit * 3;
    }

    float getExtensionDistance(float partialTicks) {
        return this.connectionAnimation.getValue(partialTicks) * this.distance / 2.0f;
    }

    float getConnectionDistance() {
        return this.distance;
    }

    public void startConnecting() {
        this.transferTimer = this.getTransferTimeout() * 2;
    }

    public void onContentTransferred() {
        int timeUnit = this.getTransferTimeout() / 2;
        this.transferTimer = timeUnit * 3;
        this.sendData();
    }

    protected Integer getTransferTimeout() {
        return (Integer)AllConfigs.SERVER.logistics.psiTimeout.get();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

