/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedCrafter;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class MechanicalCraftingCategory
extends CreateRecipeCategory<CraftingRecipe> {
    private final AnimatedCrafter crafter = new AnimatedCrafter();
    static int maxSize = 100;

    public MechanicalCraftingCategory() {
        super(MechanicalCraftingCategory.itemIcon((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get()), MechanicalCraftingCategory.emptyBackground(177, 107));
    }

    public void setIngredients(CraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList recipeIngredients = recipe.m_7527_();
        itemStacks.init(0, false, 133, 80);
        itemStacks.set(0, recipe.m_8043_());
        int x = MechanicalCraftingCategory.getXPadding(recipe);
        int y = MechanicalCraftingCategory.getYPadding(recipe);
        float scale = MechanicalCraftingCategory.getScale(recipe);
        int size = recipeIngredients.size();
        CrafterIngredientRenderer renderer = new CrafterIngredientRenderer(recipe);
        for (int i = 0; i < size; ++i) {
            float f = 19.0f * scale;
            int slotSize = (int)(16.0f * scale);
            int xPosition = (int)((float)(x + 1) + (float)(i % MechanicalCraftingCategory.getWidth(recipe)) * f);
            int yPosition = (int)((float)(y + 1) + (float)(i / MechanicalCraftingCategory.getWidth(recipe)) * f);
            itemStacks.init(i + 1, true, (IIngredientRenderer)renderer, xPosition, yPosition, slotSize, slotSize, 0, 0);
            itemStacks.set(i + 1, Arrays.asList(((Ingredient)recipeIngredients.get(i)).m_43908_()));
        }
    }

    public static float getScale(CraftingRecipe recipe) {
        int w = MechanicalCraftingCategory.getWidth(recipe);
        int h = MechanicalCraftingCategory.getHeight(recipe);
        return Math.min(1.0f, (float)maxSize / (19.0f * (float)Math.max(w, h)));
    }

    public static int getYPadding(CraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getHeight(recipe) * 19.0f) * 0.5);
    }

    public static int getXPadding(CraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getWidth(recipe) * 19.0f) * 0.5);
    }

    private static int getWidth(CraftingRecipe recipe) {
        return recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : 1;
    }

    private static int getHeight(CraftingRecipe recipe) {
        return recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeHeight() : 1;
    }

    public void draw(CraftingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        matrixStack.m_85836_();
        float scale = MechanicalCraftingCategory.getScale(recipe);
        matrixStack.m_85837_((double)MechanicalCraftingCategory.getXPadding(recipe), (double)MechanicalCraftingCategory.getYPadding(recipe), 0.0);
        for (int row = 0; row < MechanicalCraftingCategory.getHeight(recipe); ++row) {
            for (int col = 0; col < MechanicalCraftingCategory.getWidth(recipe); ++col) {
                if (((Ingredient)recipe.m_7527_().get(row * MechanicalCraftingCategory.getWidth(recipe) + col)).m_43947_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)((float)(col * 19) * scale), (double)((float)(row * 19) * scale), 0.0);
                matrixStack.m_85841_(scale, scale, scale);
                AllGuiTextures.JEI_SLOT.render(matrixStack, 0, 0);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        AllGuiTextures.JEI_SLOT.render(matrixStack, 133, 80);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 128, 59);
        this.crafter.draw(matrixStack, 129, 25);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 300.0);
        int amount = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (Ingredient.f_43901_ == ingredient) continue;
            ++amount;
        }
        Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, "" + amount, 142.0f, 39.0f, 0xFFFFFF);
        matrixStack.m_85849_();
    }

    public Class<? extends CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    private static final class CrafterIngredientRenderer
    implements IIngredientRenderer<ItemStack> {
        private final CraftingRecipe recipe;

        public CrafterIngredientRenderer(CraftingRecipe recipe) {
            this.recipe = recipe;
        }

        public void render(PoseStack matrixStack, int xPosition, int yPosition, ItemStack ingredient) {
            matrixStack.m_85836_();
            float scale = MechanicalCraftingCategory.getScale(this.recipe);
            matrixStack.m_85841_(scale, scale, scale);
            if (ingredient != null) {
                PoseStack modelViewStack = RenderSystem.m_157191_();
                modelViewStack.m_85836_();
                modelViewStack.m_166854_(matrixStack.m_85850_().m_85861_());
                RenderSystem.m_157182_();
                RenderSystem.m_69482_();
                Minecraft minecraft = Minecraft.m_91087_();
                Font font = this.getFontRenderer(minecraft, ingredient);
                ItemRenderer itemRenderer = minecraft.m_91291_();
                itemRenderer.m_115218_(ingredient, xPosition, yPosition);
                itemRenderer.m_115174_(font, ingredient, xPosition, yPosition, null);
                RenderSystem.m_69461_();
                modelViewStack.m_85849_();
                RenderSystem.m_157182_();
            }
            matrixStack.m_85849_();
        }

        public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            try {
                return ingredient.m_41651_((Player)player, tooltipFlag);
            }
            catch (LinkageError | RuntimeException e) {
                ArrayList<Component> list = new ArrayList<Component>();
                TranslatableComponent crash = new TranslatableComponent("jei.tooltip.error.crash");
                list.add((Component)crash.m_130940_(ChatFormatting.RED));
                return list;
            }
        }
    }
}

