/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import jeresources.api.drop.PlantDrop;
import jeresources.compatibility.CompatBase;
import jeresources.entry.PlantEntry;
import jeresources.util.RenderHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PlantWrapper
implements IRecipeCategoryExtension,
IRecipeSlotTooltipCallback {
    protected final PlantEntry plantEntry;
    private BlockState state;
    private Property<?> ageProperty;
    private long timer = -1L;
    private static final int TICKS = 500;

    public PlantWrapper(PlantEntry entry) {
        this.plantEntry = entry;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack poseStack, double mouseX, double mouseY) {
        RenderHelper.renderBlock(poseStack, this.getFarmland(), 30.0f, 30.0f, -10.0f, 20.0f, 20.0f);
        RenderHelper.renderBlock(poseStack, this.getBlockState(), 30.0f, 12.0f, 10.0f, 20.0f, 20.0f);
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, @NotNull List<Component> tooltip) {
        if (recipeSlotView.getRole() != RecipeIngredientRole.INPUT) {
            tooltip.add(this.getChanceString((ItemStack)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
        }
    }

    public float getChance(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return switch (drop.getDropKind()) {
            case PlantDrop.DropKind.chance -> drop.getChance();
            case PlantDrop.DropKind.weight -> (float)drop.getWeight() / (float)this.plantEntry.getTotalWeight();
            case PlantDrop.DropKind.minMax -> Float.NaN;
            default -> 0.0f;
        };
    }

    public int[] getMinMax(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private Component getChanceString(ItemStack itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (String)(minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return new TextComponent(toPrint);
    }

    private BlockState getBlockState() {
        if (this.state == null) {
            this.state = this.plantEntry.getPlantState() != null ? this.plantEntry.getPlantState() : (this.plantEntry.getPlant() != null ? this.plantEntry.getPlant().getPlant((BlockGetter)CompatBase.getLevel(), BlockPos.f_121853_) : Block.m_49814_((Item)this.plantEntry.getPlantItemStack().m_41720_()).m_49966_());
            if (this.plantEntry.getAgeProperty() != null) {
                this.ageProperty = this.plantEntry.getAgeProperty();
            } else {
                this.state.m_61147_().stream().filter(p -> p.m_61708_().equals("age")).findAny().ifPresent(property -> {
                    this.ageProperty = property;
                });
            }
        }
        if (this.ageProperty != null) {
            if (this.timer == -1L) {
                this.timer = System.currentTimeMillis() + 500L;
            } else if (System.currentTimeMillis() > this.timer) {
                this.state = (BlockState)this.state.m_61122_(this.ageProperty);
                this.timer = System.currentTimeMillis() + 500L;
            }
        }
        return this.state;
    }

    private BlockState getFarmland() {
        if (this.plantEntry.getSoil() != null) {
            return this.plantEntry.getSoil();
        }
        return Blocks.f_50093_.m_49966_();
    }
}

