/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod.EventBusSubscriber(modid="farmersdelight")
public class MappingEvents {
    public static ResourceLocation mapping(String name) {
        return new ResourceLocation("farmersdelight", name);
    }

    @SubscribeEvent
    public static void blockRemapping(RegistryEvent.MissingMappings<Block> event) {
        ImmutableList mappings = event.getMappings("farmersdelight");
        ImmutableMap blockRemapping = new ImmutableMap.Builder().put((Object)MappingEvents.mapping("oak_pantry"), ModBlocks.OAK_CABINET).put((Object)MappingEvents.mapping("birch_pantry"), ModBlocks.BIRCH_CABINET).put((Object)MappingEvents.mapping("spruce_pantry"), ModBlocks.SPRUCE_CABINET).put((Object)MappingEvents.mapping("jungle_pantry"), ModBlocks.JUNGLE_CABINET).put((Object)MappingEvents.mapping("acacia_pantry"), ModBlocks.ACACIA_CABINET).put((Object)MappingEvents.mapping("dark_oak_pantry"), ModBlocks.DARK_OAK_CABINET).put((Object)MappingEvents.mapping("crimson_pantry"), ModBlocks.CRIMSON_CABINET).put((Object)MappingEvents.mapping("warped_pantry"), ModBlocks.WARPED_CABINET).put((Object)MappingEvents.mapping("rice_crop"), ModBlocks.RICE_CROP).put((Object)MappingEvents.mapping("rice_upper_crop"), ModBlocks.RICE_CROP_PANICLES).build();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            Block block;
            Supplier blockSupplier = (Supplier)blockRemapping.get(mapping.key);
            if (blockSupplier == null || (block = (Block)blockSupplier.get()).getRegistryName() == null) continue;
            mapping.remap((IForgeRegistryEntry)block);
            FarmersDelight.LOGGER.warn("Remapping block '{}' to '{}'...", (Object)mapping.key.toString(), (Object)block.getRegistryName().toString());
        }
    }

    @SubscribeEvent
    public static void itemRemapping(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList mappings = event.getMappings("farmersdelight");
        ImmutableMap itemRemapping = new ImmutableMap.Builder().put((Object)MappingEvents.mapping("oak_pantry"), ModItems.OAK_CABINET).put((Object)MappingEvents.mapping("birch_pantry"), ModItems.BIRCH_CABINET).put((Object)MappingEvents.mapping("spruce_pantry"), ModItems.SPRUCE_CABINET).put((Object)MappingEvents.mapping("jungle_pantry"), ModItems.JUNGLE_CABINET).put((Object)MappingEvents.mapping("acacia_pantry"), ModItems.ACACIA_CABINET).put((Object)MappingEvents.mapping("dark_oak_pantry"), ModItems.DARK_OAK_CABINET).put((Object)MappingEvents.mapping("crimson_pantry"), ModItems.CRIMSON_CABINET).put((Object)MappingEvents.mapping("warped_pantry"), ModItems.WARPED_CABINET).build();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            Item item;
            Supplier itemSupplier = (Supplier)itemRemapping.get(mapping.key);
            if (itemSupplier == null || (item = (Item)itemSupplier.get()) == null || item.getRegistryName() == null) continue;
            mapping.remap((IForgeRegistryEntry)item);
            FarmersDelight.LOGGER.warn("Remapping item '{}' to '{}'...", (Object)mapping.key.toString(), (Object)item.getRegistryName().toString());
        }
    }
}

