/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.items.IItemHandler;

public class DrawerItemHandler
implements IItemHandler {
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    private IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        if (!this.group.isGroupValid()) {
            return 0;
        }
        return this.group.getDrawerCount() + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.f_41583_;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.f_41583_;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = drawer.getStoredItemPrototype().m_41777_();
        stack.m_41764_(drawer.getStoredItemCount());
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        IDrawer prevDrawer;
        IDrawer drawer;
        int prevSlot;
        if (!this.group.isGroupValid()) {
            return stack;
        }
        if (this.slotIsVirtual(slot)) {
            return this.insertItemFullScan(stack, simulate);
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        int orderedSlot = --slot >= 0 && slot < order.length ? order[slot] : -1;
        int n = prevSlot = slot >= 1 && slot < order.length ? order[slot - 1] : -1;
        if (orderedSlot > 0 && (drawer = this.group.getDrawer(orderedSlot)).isEnabled() && drawer.isEmpty() && (!(prevDrawer = this.group.getDrawer(prevSlot)).isEnabled() || !prevDrawer.isEmpty())) {
            return this.insertItemFullScan(stack, simulate);
        }
        return this.insertItemInternal(orderedSlot, stack, simulate);
    }

    @Nonnull
    private ItemStack insertItemFullScan(@Nonnull ItemStack stack, boolean simulate) {
        IItemRepository itemRepo = (IItemRepository)this.group.getCapability(ITEM_REPOSITORY_CAPABILITY, null).orElse(null);
        if (itemRepo != null) {
            return itemRepo.insertItem(stack, simulate);
        }
        for (int i = 0; i < this.group.getDrawerCount() && !(stack = this.insertItemInternal(i, stack, simulate)).m_41619_(); ++i) {
        }
        return stack;
    }

    @Nonnull
    private ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int remainder;
        IDrawer drawer = this.group.getDrawer(slot);
        if (!drawer.canItemBeStored(stack)) {
            return stack;
        }
        if (drawer.isEmpty() && !simulate) {
            drawer = drawer.setStoredItem(stack);
        }
        boolean empty = drawer.isEmpty();
        int n = simulate ? Math.max(stack.m_41613_() - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (remainder = drawer.adjustStoredItemCount(stack.m_41613_()));
        if (remainder == stack.m_41613_()) {
            return stack;
        }
        if (remainder == 0) {
            return ItemStack.f_41583_;
        }
        return this.stackResult(stack, remainder);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.f_41583_;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.f_41583_;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty() || drawer.getStoredItemCount() == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack prototype = drawer.getStoredItemPrototype();
        int remaining = simulate ? Math.max(amount - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-amount);
        return this.stackResult(prototype, amount - remaining);
    }

    public int getSlotLimit(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return 0;
        }
        if (this.slotIsVirtual(slot)) {
            return Integer.MAX_VALUE;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            return drawer.getMaxCapacity(ItemStack.f_41583_);
        }
        return drawer.getMaxCapacity();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    private boolean slotIsVirtual(int slot) {
        return slot == 0;
    }

    private ItemStack stackResult(@Nonnull ItemStack stack, int amount) {
        ItemStack result = stack.m_41777_();
        result.m_41764_(amount);
        return result;
    }
}

