/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.chunkbounds;

import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkBoundsHandler {
    public static final int REGION_SIZEX = 32;
    public static final int REGION_SIZEZ = 32;
    public static final int REGION_SIZEY_CUBIC = 32;
    private static RenderMode mode = RenderMode.NONE;
    private final List<String> regionInfo = new ArrayList<String>();
    private int playerPrevRegionPosX = Integer.MIN_VALUE;
    private int playerPrevRegionPosZ = Integer.MIN_VALUE;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ChunkBoundsHandler());
    }

    public static RenderMode getMode() {
        return mode;
    }

    public static void setMode(RenderMode mode) {
        ChunkBoundsHandler.mode = mode;
    }

    public static void toggleMode() {
        RenderMode[] modes = RenderMode.values();
        mode = modes[(mode.ordinal() + 1) % modes.length];
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelLastEvent event) {
        if (mode != RenderMode.NONE && Minecraft.m_91087_().f_91066_.f_92115_ != GraphicsStatus.FABULOUS) {
            ChunkBoundsRenderer.renderOverlays(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Text event) {
        if (this.regionInfo.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        int y = 0;
        for (String text : this.regionInfo) {
            mc.f_91062_.m_92883_(event.getMatrixStack(), text, 10.0f, (float)(y += 10), 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        int newRegionZ;
        int newRegionX;
        Minecraft instance = Minecraft.m_91087_();
        if (event.phase != TickEvent.Phase.END || instance.f_91074_ == null) {
            return;
        }
        if (ChunkBoundsHandler.getMode() != RenderMode.REGIONS) {
            this.regionInfo.clear();
            this.playerPrevRegionPosX = 0;
            this.playerPrevRegionPosZ = 0;
            return;
        }
        LocalPlayer player = instance.f_91074_;
        boolean updateInfo = this.regionInfo.isEmpty();
        if (player.m_146902_().f_45578_ < 0) {
            newRegionX = (player.m_146902_().f_45578_ + 1) / 32;
            --newRegionX;
        } else {
            newRegionX = player.m_146902_().f_45578_ / 32;
        }
        if (this.playerPrevRegionPosX != newRegionX) {
            this.playerPrevRegionPosX = newRegionX;
            updateInfo = true;
        }
        if (player.m_146902_().f_45579_ < 0) {
            newRegionZ = (player.m_146902_().f_45579_ + 1) / 32;
            --newRegionZ;
        } else {
            newRegionZ = player.m_146902_().f_45579_ / 32;
        }
        if (this.playerPrevRegionPosZ != newRegionZ) {
            this.playerPrevRegionPosZ = newRegionZ;
            updateInfo = true;
        }
        if (updateInfo) {
            this.regionInfo.clear();
            this.regionInfo.add(String.format("region/r.%d.%d.mca", this.playerPrevRegionPosX, this.playerPrevRegionPosZ));
        }
    }

    public static enum RenderMode {
        NONE,
        CORNERS,
        GRID,
        REGIONS;

    }
}

