/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.api.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public abstract class LightScannerBase
implements ILightScanner {
    protected List<Pair<BlockPos, Byte>> overlayCache = new ArrayList<Pair<BlockPos, Byte>>();

    @Override
    public void update(Player player) {
        int px = (int)Math.floor(player.m_20185_());
        int py = (int)Math.floor(player.m_20186_());
        int pz = (int)Math.floor(player.m_20189_());
        int y1 = py - (Integer)Config.light_DownRange.get();
        int y2 = py + (Integer)Config.light_UpRange.get();
        int HRange = (Integer)Config.light_HRange.get();
        this.overlayCache.clear();
        int HRangeNorth = HRange;
        int HRangeEast = HRange;
        int HRangeSouth = HRange;
        int HRangeWest = HRange;
        if (HRange > 5 && (double)player.m_20155_().f_82471_ > -0.5 && (double)player.m_20155_().f_82471_ < 0.5) {
            switch (player.m_6350_()) {
                case NORTH: {
                    HRangeSouth = 5;
                    break;
                }
                case EAST: {
                    HRangeWest = 5;
                    break;
                }
                case SOUTH: {
                    HRangeNorth = 5;
                    break;
                }
                case WEST: {
                    HRangeEast = 5;
                }
            }
        }
        for (int xo = -HRangeWest; xo <= HRangeEast; ++xo) {
            for (int zo = -HRangeNorth; zo <= HRangeSouth; ++zo) {
                BlockPos pos1 = new BlockPos(px + xo, py, pz + zo);
                if (!this.shouldCheck(pos1, player.f_19853_)) continue;
                for (int y = y1; y <= y2; ++y) {
                    BlockPos pos = new BlockPos(px + xo, y, pz + zo);
                    byte mode = this.getSpawnModeAt(pos, player.f_19853_);
                    if (mode == 0) continue;
                    this.overlayCache.add((Pair<BlockPos, Byte>)Pair.of((Object)pos, (Object)mode));
                }
            }
        }
    }

    @Override
    public void clear() {
        this.overlayCache.clear();
    }

    @Override
    public List<Pair<BlockPos, Byte>> getLightModes() {
        return this.overlayCache;
    }

    public boolean shouldCheck(BlockPos pos, Level world) {
        if (world.f_46443_) {
            return true;
        }
        if (((Boolean)Config.light_IgnoreSpawnList.get()).booleanValue()) {
            return true;
        }
        Biome biome = world.m_46857_(pos);
        return biome.m_47518_().m_48344_() > 0.0f && !biome.m_47518_().m_151798_(MobCategory.MONSTER).m_146337_();
    }

    public abstract byte getSpawnModeAt(BlockPos var1, Level var2);
}

