/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.network.client.CarrySlotPacket;

public class CommandCarryOn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"carryon").then(Commands.m_82127_((String)"debug").executes(cmd -> CommandCarryOn.handleDebug((CommandSourceStack)cmd.getSource())))).then(Commands.m_82127_((String)"clear").executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(2))).executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), EntityArgument.m_91477_((CommandContext)cmd, (String)"target")))));
        dispatcher.register(builder);
    }

    private static int handleDebug(CommandSourceStack source) {
        try {
            if (source.m_81374_() != null) {
                ServerPlayer player = source.m_81375_();
                ItemStack main = player.m_21205_();
                if (!main.m_41619_() && main.m_41720_() == RegistrationHandler.itemTile) {
                    source.m_81354_((Component)new TextComponent("Block: " + ItemCarryonBlock.getBlock(main)), true);
                    source.m_81354_((Component)new TextComponent("BlockState: " + ItemCarryonBlock.getBlockState(main)), true);
                    source.m_81354_((Component)new TextComponent("ItemStack: " + ItemCarryonBlock.getItemStack(main)), true);
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))) {
                        source.m_81354_((Component)new TextComponent("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))), true);
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(main))) {
                        source.m_81354_((Component)new TextComponent("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(main))), true);
                    }
                    CarryOn.LOGGER.info("Block: " + ItemCarryonBlock.getBlock(main));
                    CarryOn.LOGGER.info("BlockState: " + ItemCarryonBlock.getBlockState(main));
                    CarryOn.LOGGER.info("ItemStack: " + ItemCarryonBlock.getItemStack(main));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(main))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(main)));
                    }
                    return 1;
                }
                if (!main.m_41619_() && main.m_41720_() == RegistrationHandler.itemEntity) {
                    source.m_81354_((Component)new TextComponent("Entity: " + ItemCarryonEntity.getEntity(main, player.f_19853_)), true);
                    source.m_81354_((Component)new TextComponent("Entity Name: " + ItemCarryonEntity.getEntityName(main)), true);
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonEntity.getEntity(main, player.f_19853_))) {
                        source.m_81354_((Component)new TextComponent("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonEntity.getEntity(main, player.f_19853_))), true);
                    }
                    CarryOn.LOGGER.info("Entity: " + ItemCarryonEntity.getEntity(main, player.f_19853_));
                    CarryOn.LOGGER.info("Entity Name: " + ItemCarryonEntity.getEntityName(main));
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonEntity.getEntity(main, player.f_19853_))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonEntity.getEntity(main, player.f_19853_)));
                    }
                    return 1;
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return 0;
    }

    private static int handleClear(CommandSourceStack source, Collection<ServerPlayer> players) {
        Iterator<ServerPlayer> iterator = players.iterator();
        if (iterator.hasNext()) {
            ServerPlayer player = iterator.next();
            int cleared = 0;
            cleared += player.m_150109_().m_36022_(stack -> !stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemTile, 64, (Container)player.f_36095_.m_39730_());
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CarrySlotPacket(9, player.m_142049_()));
            if ((cleared += player.m_150109_().m_36022_(stack -> !stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemEntity, 64, (Container)player.f_36095_.m_39730_())) != 1) {
                source.m_81354_((Component)new TextComponent("Cleared " + cleared + " Items!"), true);
            } else {
                source.m_81354_((Component)new TextComponent("Cleared " + cleared + " Item!"), true);
            }
            return 1;
        }
        return 0;
    }
}

