/*
 * Decompiled with CFR 0.152.
 */
package jeresources.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.WorldGenRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenAdapter {
    private static final String worldGenFileName = "world-gen.json";
    private static Map<ResourceKey<Level>, Restriction> map = new HashMap<ResourceKey<Level>, Restriction>();

    public static File getWorldGenFile() {
        return FMLPaths.CONFIGDIR.get().resolve(worldGenFileName).toFile();
    }

    public static boolean hasWorldGenDIYData() {
        return WorldGenAdapter.getWorldGenFile().exists();
    }

    public static boolean readDIYData() {
        try {
            JsonElement base = JsonParser.parseReader((Reader)new FileReader(WorldGenAdapter.getWorldGenFile()));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) {
                return false;
            }
            JsonArray array = base.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                JsonElement element = obj.get("mod");
                if (element != null && !ModList.get().isLoaded(element.getAsString())) continue;
                String block = obj.get("block").getAsString();
                JsonElement distribElement = obj.get("distrib");
                if (distribElement == null) continue;
                String distrib = distribElement.getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();
                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";
                String[] blockParts = block.split(":");
                Item itemBlock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(blockParts[0], blockParts[1]));
                if (itemBlock == null || itemBlock == Items.f_41852_) {
                    itemBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockParts[0], blockParts[1]))).m_5456_();
                }
                if (itemBlock == Items.f_41852_) continue;
                ItemStack blockStack = itemBlock.m_7968_();
                ArrayList<DistributionHelpers.OrePoint> points = new ArrayList<DistributionHelpers.OrePoint>();
                for (String point : distrib.split(";")) {
                    String[] split = point.split(",");
                    if (split.length != 2) continue;
                    points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                }
                DistributionCustom distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints(points.toArray(new DistributionHelpers.OrePoint[points.size()])));
                JsonElement dropsListElement = obj.get("dropsList");
                LinkedList<LootDrop> dropList = new LinkedList<LootDrop>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonElement fortuneElement;
                        String itemStackString;
                        String[] stackStrings;
                        Item item;
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull() || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((stackStrings = (itemStackString = itemStackElement.getAsString()).split(":", 4))[0], stackStrings[1]))) == null) continue;
                        ItemStack itemStack = new ItemStack((ItemLike)item);
                        if (stackStrings.length >= 3) {
                            itemStack.m_41721_(Integer.valueOf(stackStrings[2]).intValue());
                        }
                        if (stackStrings.length == 4) {
                            try {
                                itemStack.m_41751_(TagParser.m_129359_((String)stackStrings[3]));
                            }
                            catch (CommandSyntaxException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((fortuneElement = drop.get("fortunes")) == null) continue;
                        JsonObject fortunes = fortuneElement.getAsJsonObject();
                        for (Map.Entry fortuneValue : fortunes.entrySet()) {
                            int fortuneLevel = Integer.valueOf((String)fortuneValue.getKey());
                            float dropAmount = ((JsonElement)fortuneValue.getValue()).getAsFloat();
                            dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                        }
                    }
                }
                if ((blockStack.m_41619_() || blockStack.m_41720_() == Items.f_41852_) && dropList.size() > 0) {
                    blockStack = ((LootDrop)dropList.get((int)0)).item.m_41777_();
                    blockStack.m_41764_(1);
                }
                WorldGenRegistry.getInstance().registerEntry(new WorldGenEntry(blockStack, (DistributionBase)distribution, WorldGenAdapter.getRestriction(dim), silktouch, dropList.toArray(new LootDrop[dropList.size()])));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Restriction getRestriction(String dim) {
        ResourceKey worldRegistryKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim));
        return map.computeIfAbsent((ResourceKey<Level>)worldRegistryKey, k -> new Restriction(new DimensionRestriction((ResourceKey<Level>)worldRegistryKey)));
    }
}

