/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.element.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.GuiUtils;

public class TextWindowElement
extends AnimatedOverlayElement {
    Supplier<String> textGetter = () -> "(?) No text was provided";
    String bakedText;
    int y;
    Vec3 vec;
    boolean nearScene = false;
    int color = PonderPalette.WHITE.getColor();

    @Override
    protected void render(PonderScene scene, PonderUI screen, PoseStack ms, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        Vec2 sceneToScreen = this.vec != null ? scene.getTransform().sceneToScreen(this.vec, partialTicks) : new Vec2((float)(screen.f_96543_ / 2), (float)((screen.f_96544_ - 200) / 2 + this.y - 8));
        float yDiff = ((float)screen.f_96544_ / 2.0f - sceneToScreen.f_82471_ - 10.0f) / 100.0f;
        int targetX = (int)((float)screen.f_96543_ * Mth.m_14179_((float)(yDiff * yDiff), (float)0.75f, (float)0.625f));
        if (this.nearScene) {
            targetX = (int)Math.min((float)targetX, sceneToScreen.f_82470_ + 50.0f);
        }
        int textWidth = Math.min(screen.f_96543_ - targetX, 180);
        List lines = screen.getFontRenderer().m_92865_().m_92432_(this.bakedText, textWidth, Style.f_131099_);
        int boxWidth = 0;
        for (FormattedText line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().m_92852_(line));
        }
        int boxHeight = screen.getFontRenderer().m_92920_(this.bakedText, boxWidth);
        ms.m_85836_();
        ms.m_85837_(0.0, (double)sceneToScreen.f_82471_, 400.0);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.TEXT_WINDOW_BORDER))).at(targetX - 10, 3.0f, 100.0f)).withBounds(boxWidth, boxHeight - 1)).render(ms);
        int brighterColor = Color.mixColors(this.color, -35, 0.5f);
        if (this.vec != null) {
            ms.m_85836_();
            ms.m_85837_((double)sceneToScreen.f_82470_, 0.0, 0.0);
            double lineTarget = ((float)targetX - sceneToScreen.f_82470_) * fade;
            ms.m_85841_((float)lineTarget, 1.0f, 1.0f);
            Matrix4f model = ms.m_85850_().m_85861_();
            GuiUtils.drawGradientRect((Matrix4f)model, (int)-100, (int)0, (int)0, (int)1, (int)1, (int)brighterColor, (int)brighterColor);
            GuiUtils.drawGradientRect((Matrix4f)model, (int)-100, (int)0, (int)1, (int)1, (int)2, (int)-11974327, (int)-13027015);
            ms.m_85849_();
        }
        ms.m_85837_(0.0, 0.0, 400.0);
        for (int i = 0; i < lines.size(); ++i) {
            screen.getFontRenderer().m_92883_(ms, ((FormattedText)lines.get(i)).getString(), (float)(targetX - 10), (float)(3 + 9 * i), new Color(brighterColor).scaleAlpha(fade).getRGB());
        }
        ms.m_85849_();
    }

    public int getColor() {
        return this.color;
    }

    public class Builder {
        private PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        public Builder colored(PonderPalette color) {
            TextWindowElement.this.color = color.getColor();
            return this;
        }

        public Builder pointAt(Vec3 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        public Builder independent() {
            return this.independent(0);
        }

        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        public Builder sharedText(ResourceLocation key) {
            TextWindowElement.this.textGetter = () -> PonderLocalization.getShared(key);
            return this;
        }

        public Builder sharedText(String key) {
            return this.sharedText(new ResourceLocation(this.scene.getNamespace(), key));
        }

        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

