/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.TickableGuiEventListener;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSimiScreen
extends Screen {
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;

    protected AbstractSimiScreen(Component title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(TextComponent.f_131282_);
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.windowWidth) / 2;
        this.guiTop = (this.f_96544_ - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void m_96624_() {
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected <W extends GuiEventListener & Widget> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.m_142416_((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Widget> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_142416_(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.m_169411_(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.m_169411_(guiEventListener);
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.f_96541_.m_91296_();
        ms.m_85836_();
        this.prepareFrame();
        this.renderWindowBackground(ms, mouseX, mouseY, partialTicks);
        this.renderWindow(ms, mouseX, mouseY, partialTicks);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.renderWindowForeground(ms, mouseX, mouseY, partialTicks);
        this.endFrame();
        ms.m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.m_7933_(keyCode, scanCode, modifiers);
        if (keyPressed || this.m_7222_() != null) {
            return keyPressed;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
    }

    protected abstract void renderWindow(PoseStack var1, int var2, int var3, float var4);

    protected void renderWindowForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.f_169369_) {
            List<Component> tooltip;
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).m_198029_() || (tooltip = simiWidget.getToolTip()).isEmpty()) continue;
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        }
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(PoseStack matrixStack) {
        AbstractSimiScreen.m_93172_((PoseStack)matrixStack, (int)(this.guiLeft + this.windowWidth), (int)(this.guiTop + this.windowHeight), (int)this.guiLeft, (int)this.guiTop, (int)-741092397);
    }
}

