/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.vault;

import com.simibubi.create.content.logistics.block.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.block.vault.ItemVaultTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class ItemVaultConnectivityHandler {
    public static void formVaults(ItemVaultTileEntity te) {
        VaultSearchCache cache = new VaultSearchCache();
        ArrayList<ItemVaultTileEntity> frontier = new ArrayList<ItemVaultTileEntity>();
        frontier.add(te);
        ItemVaultConnectivityHandler.formVaults(te.m_58903_(), (BlockGetter)te.m_58904_(), cache, frontier);
    }

    private static void formVaults(BlockEntityType<?> type, BlockGetter world, VaultSearchCache cache, List<ItemVaultTileEntity> frontier) {
        PriorityQueue<Pair<Integer, ItemVaultTileEntity>> creationQueue = ItemVaultConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int minY = Integer.MAX_VALUE;
        for (ItemVaultTileEntity fluidTankTileEntity : frontier) {
            BlockPos pos = fluidTankTileEntity.m_58899_();
            minY = Math.min(pos.m_123342_(), minY);
        }
        minY -= 3;
        while (!frontier.isEmpty()) {
            ItemVaultTileEntity tank = frontier.remove(0);
            BlockPos tankPos = tank.m_58899_();
            if (visited.contains(tankPos)) continue;
            visited.add(tankPos);
            int amount = ItemVaultConnectivityHandler.tryToFormNewVault(tank, cache, true);
            if (amount > 1) {
                creationQueue.add((Pair<Integer, ItemVaultTileEntity>)Pair.of((Object)amount, (Object)tank));
            }
            for (Direction.Axis axis : Iterate.axes) {
                ItemVaultTileEntity nextTank;
                Direction d = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
                BlockPos next = tankPos.m_142300_(d);
                if (next.m_123342_() <= minY || visited.contains(next) || (nextTank = ItemVaultConnectivityHandler.vaultAt(type, world, next)) == null || nextTank.m_58901_()) continue;
                frontier.add(nextTank);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, ItemVaultTileEntity> next = creationQueue.poll();
            ItemVaultTileEntity toCreate = (ItemVaultTileEntity)next.getValue();
            if (visited.contains(toCreate.m_58899_())) continue;
            visited.add(toCreate.m_58899_());
            ItemVaultConnectivityHandler.tryToFormNewVault(toCreate, cache, false);
        }
    }

    public static void splitVault(ItemVaultTileEntity te) {
        ItemVaultConnectivityHandler.splitVaultAndInvalidate(te, null, false);
    }

    private static int tryToFormNewVault(ItemVaultTileEntity te, VaultSearchCache cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!te.isController()) {
            return 0;
        }
        for (int w = 1; w <= 3; ++w) {
            int amount = ItemVaultConnectivityHandler.tryToFormNewVaultOfRadius(te, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            if (te.radius == bestWidth && te.radius * te.radius * te.length == bestAmount) {
                return bestAmount;
            }
            ItemVaultConnectivityHandler.splitVaultAndInvalidate(te, cache, false);
            ItemVaultConnectivityHandler.tryToFormNewVaultOfRadius(te, bestWidth, cache, simulate);
            te.updateConnectivity = false;
            te.radius = bestWidth;
            te.length = bestAmount / bestWidth / bestWidth;
            BlockState state = te.m_58900_();
            if (ItemVaultBlock.isVault(state)) {
                te.m_58904_().m_7731_(te.m_58899_(), (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(te.radius > 2)), 22);
            }
            te.itemCapability.invalidate();
            te.m_6596_();
        }
        return bestAmount;
    }

    private static int tryToFormNewVaultOfRadius(ItemVaultTileEntity te, int width, VaultSearchCache cache, boolean simulate) {
        Object tank;
        BlockPos pos;
        int zOffset;
        int xOffset;
        int yOffset;
        int amount = 0;
        int height = 0;
        BlockEntityType type = te.m_58903_();
        Level world = te.m_58904_();
        BlockPos origin = te.m_58899_();
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(te.m_58900_()) == Direction.Axis.Z;
        block0: for (yOffset = 0; yOffset < ItemVaultTileEntity.getMaxLength(width); ++yOffset) {
            for (xOffset = 0; xOffset < width; ++xOffset) {
                for (zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos controllerPos;
                    pos = alongZ ? origin.m_142082_(xOffset, zOffset, yOffset) : origin.m_142082_(yOffset, xOffset, zOffset);
                    tank = cache.getOrCache(type, (BlockGetter)world, pos);
                    if (!((Optional)tank).isPresent()) break block0;
                    ItemVaultTileEntity controller = ((Optional)tank).get();
                    int otherWidth = controller.radius;
                    if (otherWidth > width || otherWidth == width && controller.length == ItemVaultTileEntity.getMaxLength(width) || ItemVaultBlock.getVaultBlockAxis(controller.m_58900_()) == Direction.Axis.Z != alongZ || !(controllerPos = controller.m_58899_()).equals((Object)origin) && (alongZ && controllerPos.m_123341_() < origin.m_123341_() || controllerPos.m_123342_() < origin.m_123342_() || !alongZ && controllerPos.m_123343_() < origin.m_123343_() || alongZ && controllerPos.m_123341_() + otherWidth > origin.m_123341_() + width || controllerPos.m_123342_() + otherWidth > origin.m_123342_() + width || !alongZ && controllerPos.m_123343_() + otherWidth > origin.m_123343_() + width)) break block0;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        for (yOffset = 0; yOffset < height; ++yOffset) {
            for (xOffset = 0; xOffset < width; ++xOffset) {
                for (zOffset = 0; zOffset < width; ++zOffset) {
                    pos = alongZ ? origin.m_142082_(xOffset, zOffset, yOffset) : origin.m_142082_(yOffset, xOffset, zOffset);
                    tank = ItemVaultConnectivityHandler.vaultAt(type, (BlockGetter)world, pos);
                    if (tank == te) continue;
                    ItemVaultConnectivityHandler.splitVaultAndInvalidate((ItemVaultTileEntity)tank, cache, false);
                    ((ItemVaultTileEntity)tank).setController(origin);
                    ((ItemVaultTileEntity)tank).updateConnectivity = false;
                    cache.put(pos, te);
                    BlockState state = world.m_8055_(pos);
                    if (!ItemVaultBlock.isVault(state)) continue;
                    state = (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(width > 2));
                    world.m_7731_(pos, state, 22);
                }
            }
        }
        return amount;
    }

    private static void splitVaultAndInvalidate(ItemVaultTileEntity te, @Nullable VaultSearchCache cache, boolean tryReconnect) {
        boolean alongZ;
        if ((te = te.getControllerTE()) == null) {
            return;
        }
        int height = te.length;
        int width = te.radius;
        BlockState state = te.m_58900_();
        boolean bl = alongZ = ItemVaultBlock.getVaultBlockAxis(state) == Direction.Axis.Z;
        if (width == 1 && height == 1) {
            return;
        }
        Level world = te.m_58904_();
        BlockPos origin = te.m_58899_();
        ArrayList<ItemVaultTileEntity> frontier = new ArrayList<ItemVaultTileEntity>();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = alongZ ? origin.m_142082_(xOffset, zOffset, yOffset) : origin.m_142082_(yOffset, xOffset, zOffset);
                    ItemVaultTileEntity tankAt = ItemVaultConnectivityHandler.vaultAt(te.m_58903_(), (BlockGetter)world, pos);
                    if (tankAt == null || !tankAt.getController().equals((Object)origin)) continue;
                    tankAt.removeController(true);
                    if (tryReconnect) {
                        frontier.add(tankAt);
                        tankAt.updateConnectivity = false;
                    }
                    if (cache == null) continue;
                    cache.put(pos, tankAt);
                }
            }
        }
        te.itemCapability.invalidate();
        if (tryReconnect) {
            ItemVaultConnectivityHandler.formVaults(te.m_58903_(), (BlockGetter)world, cache == null ? new VaultSearchCache() : cache, frontier);
        }
    }

    private static PriorityQueue<Pair<Integer, ItemVaultTileEntity>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, ItemVaultTileEntity>>(new Comparator<Pair<Integer, ItemVaultTileEntity>>(){

            @Override
            public int compare(Pair<Integer, ItemVaultTileEntity> o1, Pair<Integer, ItemVaultTileEntity> o2) {
                return (Integer)o2.getKey() - (Integer)o1.getKey();
            }
        });
    }

    @Nullable
    public static ItemVaultTileEntity vaultAt(BlockEntityType<?> type, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ItemVaultTileEntity && te.m_58903_() == type) {
            return (ItemVaultTileEntity)te;
        }
        return null;
    }

    public static boolean isConnected(BlockGetter world, BlockPos tankPos, BlockPos otherTankPos) {
        BlockEntity te1 = world.m_7702_(tankPos);
        BlockEntity te2 = world.m_7702_(otherTankPos);
        if (!(te1 instanceof ItemVaultTileEntity) || !(te2 instanceof ItemVaultTileEntity)) {
            return false;
        }
        return ((ItemVaultTileEntity)te1).getController().equals((Object)((ItemVaultTileEntity)te2).getController());
    }

    private static class VaultSearchCache {
        Map<BlockPos, Optional<ItemVaultTileEntity>> controllerMap = new HashMap<BlockPos, Optional<ItemVaultTileEntity>>();

        void put(BlockPos pos, ItemVaultTileEntity target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<ItemVaultTileEntity> getOrCache(BlockEntityType<?> type, BlockGetter world, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            ItemVaultTileEntity tankAt = ItemVaultConnectivityHandler.vaultAt(type, world, pos);
            if (tankAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            ItemVaultTileEntity controller = tankAt.getControllerTE();
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

