/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidValveInstance
extends ShaftInstance
implements DynamicInstance {
    private final FluidValveTileEntity tile;
    protected ModelData pointer;
    protected final double xRot;
    protected final double yRot;
    protected final int pointerRotationOffset;

    public FluidValveInstance(MaterialManager dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.tile = (FluidValveTileEntity)tile;
        Direction facing = (Direction)this.blockState.m_61143_((Property)FluidValveBlock.FACING);
        this.yRot = AngleHelper.horizontalAngle(facing);
        this.xRot = facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0);
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(this.blockState);
        Direction.Axis shaftAxis = KineticTileEntityRenderer.getRotationAxisOf(tile);
        boolean twist = pipeAxis.m_122479_() && shaftAxis == Direction.Axis.X || pipeAxis.m_122478_();
        this.pointerRotationOffset = twist ? 90 : 0;
        this.pointer = (ModelData)this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.FLUID_VALVE_POINTER, this.blockState).createInstance();
        this.transformPointer();
    }

    public void beginFrame() {
        if (this.tile.pointer.settled()) {
            return;
        }
        this.transformPointer();
    }

    private void transformPointer() {
        float pointerRotation = Mth.m_14179_((float)this.tile.pointer.getValue(AnimationTickHolder.getPartialTicks()), (float)0.0f, (float)-90.0f);
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.pointer.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY(this.yRot)).rotateX(this.xRot)).rotateY((double)((float)this.pointerRotationOffset + pointerRotation))).unCentre();
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pointer});
    }

    @Override
    public void remove() {
        super.remove();
        this.pointer.delete();
    }
}

