/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.Backend;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.Vec3;

public final class OptifineHandler {
    public static final String OPTIFINE_ROOT_PACKAGE = "net.optifine";
    public static final String SHADER_PACKAGE = "net.optifine.shaders";
    private static boolean isOptifineInstalled;
    private static BooleanSupplier shadersEnabledSupplier;
    private static BooleanSupplier shadowPassSupplier;
    private static FrustumConstructor shadowFrustumConstructor;

    private OptifineHandler() {
    }

    private static FrustumConstructor createShadowFrustumConstructor() {
        try {
            Class<?> ofShaders = Class.forName("net.optifine.shaders.ShadersRender");
            Method method = ofShaders.getDeclaredMethod("makeShadowFrustum", Camera.class, Float.TYPE);
            method.setAccessible(true);
            return (cam, pt) -> {
                try {
                    return (Frustum)method.invoke(null, cam, Float.valueOf(pt));
                }
                catch (Exception ignored) {
                    return null;
                }
            };
        }
        catch (Exception ignored) {
            return ($, $$) -> null;
        }
    }

    private static BooleanSupplier createShadowPassSupplier() {
        try {
            Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
            Field field = ofShaders.getDeclaredField("isShadowPass");
            field.setAccessible(true);
            return () -> {
                try {
                    return field.getBoolean(null);
                }
                catch (IllegalAccessException ignored) {
                    return false;
                }
            };
        }
        catch (Exception ignored) {
            return () -> false;
        }
    }

    private static BooleanSupplier createShadersEnabledSupplier() {
        try {
            Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
            Field field = ofShaders.getDeclaredField("shaderPackLoaded");
            field.setAccessible(true);
            return () -> {
                try {
                    return field.getBoolean(null);
                }
                catch (IllegalAccessException ignored) {
                    return false;
                }
            };
        }
        catch (Exception ignored) {
            return () -> false;
        }
    }

    public static void init() {
        Package optifinePackage = Package.getPackage(OPTIFINE_ROOT_PACKAGE);
        boolean bl = isOptifineInstalled = optifinePackage != null;
        if (isOptifineInstalled) {
            Backend.LOGGER.info("Optifine detected.");
        } else {
            Backend.LOGGER.info("Optifine not detected.");
        }
        shadersEnabledSupplier = OptifineHandler.createShadersEnabledSupplier();
        shadowPassSupplier = OptifineHandler.createShadowPassSupplier();
        shadowFrustumConstructor = OptifineHandler.createShadowFrustumConstructor();
    }

    public static boolean isOptifineInstalled() {
        return isOptifineInstalled;
    }

    public static boolean isUsingShaders() {
        return shadersEnabledSupplier.getAsBoolean();
    }

    public static boolean isShadowPass() {
        return shadowPassSupplier.getAsBoolean();
    }

    @Nullable
    public static Frustum createShadowFrustum(Camera camera, float partialTicks) {
        Frustum frustum = shadowFrustumConstructor.create(camera, partialTicks);
        if (frustum != null) {
            Vec3 position = camera.m_90583_();
            frustum.m_113002_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        return frustum;
    }

    @FunctionalInterface
    public static interface FrustumConstructor {
        @Nullable
        public Frustum create(Camera var1, float var2);
    }
}

