/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsHandler;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.apache.commons.lang3.tuple.Pair;

public class LightOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static final EntityRenderDispatcher render = Minecraft.m_91087_().m_91290_();
    private static Tesselator tess;
    private static BufferBuilder renderer;
    private static Minecraft minecraft;

    public LightOverlayRenderer() {
        tess = Tesselator.m_85913_();
        renderer = tess.m_85915_();
        minecraft = Minecraft.m_91087_();
    }

    private static void renderCross(PoseStack matrixstack, BlockPos pos, float r, float g, float b) {
        LocalPlayer player = LightOverlayRenderer.minecraft.f_91074_;
        BlockState blockStateBelow = player.f_19853_.m_8055_(pos);
        float y = 0.0f;
        y = blockStateBelow.m_60767_() == Material.f_76308_ ? ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + ((float)pos.m_123342_() + 0.125f) : (float)((double)(0.005f + ((float)pos.m_123342_() + 0.125f)) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0))) : ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + (float)pos.m_123342_() : (float)((double)(0.005f + (float)pos.m_123342_()) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0)));
        float x0 = pos.m_123341_();
        float x1 = x0 + 1.0f;
        float z0 = pos.m_123343_();
        float z1 = z0 + 1.0f;
        Matrix4f matrix4f = matrixstack.m_85850_().m_85861_();
        Camera camera = LightOverlayRenderer.minecraft.f_91063_.m_109153_();
        float cameraX = (float)camera.m_90583_().f_82479_;
        float cameraY = (float)camera.m_90583_().f_82480_;
        float cameraZ = (float)camera.m_90583_().f_82481_;
        renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z0 - cameraZ).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z1 - cameraZ).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z0 - cameraZ).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z1 - cameraZ).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            return;
        }
        Minecraft.m_91087_().m_91097_().m_174784_(BLANK_TEX);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_69832_((float)((float)((Double)Config.render_chunkLineWidth.get()).doubleValue()));
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Quaternion cameraRotation = Minecraft.m_91087_().f_91063_.m_109153_().m_90591_();
        if (Minecraft.m_91087_().f_91066_.f_92115_ != GraphicsStatus.FABULOUS) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69481_();
        } else {
            matrixstack.m_85836_();
            if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.NONE) {
                cameraRotation.m_80148_(new Quaternion(new Vector3f(0.0f, -1.0f, 0.0f), 180.0f, true));
            }
            Matrix4f translateMatrix = new Matrix4f(cameraRotation);
            matrixstack.m_166854_(translateMatrix);
        }
        float ar = (float)((Integer)Config.render_spawnAColor.get() >> 16 & 0xFF) / 255.0f;
        float ag = (float)((Integer)Config.render_spawnAColor.get() >> 8 & 0xFF) / 255.0f;
        float ab = (float)((Integer)Config.render_spawnAColor.get() & 0xFF) / 255.0f;
        float nr = (float)((Integer)Config.render_spawnNColor.get() >> 16 & 0xFF) / 255.0f;
        float ng = (float)((Integer)Config.render_spawnNColor.get() >> 8 & 0xFF) / 255.0f;
        float nb = (float)((Integer)Config.render_spawnNColor.get() & 0xFF) / 255.0f;
        renderer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
            Byte mode = (Byte)entry.getValue();
            if (mode == null || mode == 0) continue;
            if (mode == 1) {
                LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), nr, ng, nb);
                continue;
            }
            if (mode != 2) continue;
            LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), ar, ag, ab);
        }
        tess.m_85914_();
        RenderSystem.m_69493_();
        if (Minecraft.m_91087_().f_91066_.f_92115_ != GraphicsStatus.FABULOUS) {
            RenderSystem.m_69464_();
            RenderSystem.m_69458_((boolean)true);
        } else {
            RenderSystem.m_69832_((float)1.0f);
            RenderSystem.m_69478_();
            cameraRotation.m_80148_(new Quaternion(new Vector3f(0.0f, -1.0f, 0.0f), -180.0f, true));
            Matrix4f translateMatrix = new Matrix4f(cameraRotation);
            matrixstack.m_166854_(translateMatrix);
            matrixstack.m_85849_();
        }
    }
}

