/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.batching;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.struct.Batched;
import com.jozufozu.flywheel.backend.instancing.AbstractInstancer;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.ModelTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;

public class CPUInstancer<D extends InstanceData>
extends AbstractInstancer<D> {
    private final Batched<D> batchingType;
    final ModelTransformer sbb;

    public CPUInstancer(Batched<D> type, Model modelData) {
        super(type::create, modelData);
        this.batchingType = type;
        this.sbb = new ModelTransformer(modelData);
    }

    void submitTasks(PoseStack stack, TaskEngine pool, DirectVertexConsumer consumer) {
        int instances = this.getInstanceCount();
        while (instances > 0) {
            int end = instances;
            int start = Math.max(instances -= 512, 0);
            int verts = this.getModelVertexCount() * (end - start);
            DirectVertexConsumer sub = consumer.split(verts);
            pool.submit(() -> this.drawRange(stack, sub, start, end));
        }
    }

    private void drawRange(PoseStack stack, VertexConsumer buffer, int from, int to) {
        ModelTransformer.Params params = new ModelTransformer.Params();
        for (InstanceData d : this.data.subList(from, to)) {
            params.loadDefault();
            this.batchingType.transform(d, params);
            this.sbb.renderInto(params, stack, buffer);
        }
    }

    void drawAll(PoseStack stack, VertexConsumer buffer) {
        ModelTransformer.Params params = new ModelTransformer.Params();
        for (InstanceData d : this.data) {
            params.loadDefault();
            this.batchingType.transform(d, params);
            this.sbb.renderInto(params, stack, buffer);
        }
    }

    void setup() {
        if (this.anyToRemove) {
            this.data.removeIf(InstanceData::isRemoved);
            this.anyToRemove = false;
        }
    }

    @Override
    public void notifyDirty() {
    }
}

