/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.GlFence;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.Mappable;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.error.GlError;
import com.jozufozu.flywheel.backend.gl.error.GlException;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL30;

public class PersistentGlBuffer
extends GlBuffer
implements Mappable {
    private MappedBuffer buffer;
    int flags = 194;
    long size;
    GlFence fence = new GlFence();

    public PersistentGlBuffer(GlBufferType type) {
        super(type);
    }

    @Override
    public void doneForThisFrame() {
        this.fence.post();
    }

    @Override
    protected void alloc(long size) {
        this.size = size;
        if (this.buffer != null) {
            this.deleteInternal(this.handle());
            this._create();
            this.bind();
        }
        this.fence.clear();
        GlCompat.getInstance().bufferStorage.bufferStorage(this.type, size, this.flags);
        ByteBuffer byteBuffer = GL30.glMapBufferRange((int)this.type.glEnum, (long)0L, (long)size, (int)this.flags);
        if (byteBuffer == null) {
            throw new GlException(GlError.poll(), "Could not map buffer");
        }
        this.buffer = new MappedBuffer(this, byteBuffer, 0L, size);
    }

    @Override
    public void upload(ByteBuffer directBuffer) {
        throw new UnsupportedOperationException("FIXME: Nothing calls #upload on a persistent buffer as of 12/10/2021.");
    }

    @Override
    public MappedBuffer getBuffer(long offset, long length) {
        this.fence.waitSync();
        this.buffer.position((int)offset);
        return this.buffer;
    }

    @Override
    public GlBufferType getType() {
        return this.type;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }
}

