/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.api;

import com.jozufozu.flywheel.api.Instancer;

public abstract class InstanceData {
    private Instancer<?> owner;
    private boolean dirty;
    private boolean removed;

    public final void markDirty() {
        this.dirty = true;
        this.owner.notifyDirty();
    }

    public final void delete() {
        this.removed = true;
        this.owner.notifyRemoval();
    }

    public final boolean checkDirtyAndClear() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public Instancer<?> getOwner() {
        return this.owner;
    }

    public InstanceData setOwner(Instancer<?> owner) {
        this.owner = owner;
        return this;
    }
}

