/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.config.BackendTypeArgument;
import com.jozufozu.flywheel.config.FlwCommands;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.StitchedSprite;
import com.jozufozu.flywheel.core.compile.ProgramCompiler;
import com.jozufozu.flywheel.mixin.PausedPartialTickAccessor;
import com.jozufozu.flywheel.vanilla.VanillaInstances;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.slf4j.Logger;

@Mod(value="flywheel")
public class Flywheel {
    public static final String ID = "flywheel";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ArtifactVersion version;

    public Flywheel() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        version = modLoadingContext.getActiveContainer().getModInfo().getVersion();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(Flywheel::setup);
        FlwConfig.init();
        modLoadingContext.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (serverVersion, isNetwork) -> isNetwork));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Flywheel.clientInit(forgeEventBus, modEventBus));
    }

    private static void clientInit(IEventBus forgeEventBus, IEventBus modEventBus) {
        CrashReportCallables.registerCrashCallable((String)"Flywheel Backend", Backend::getBackendDescriptor);
        ShadersModHandler.init();
        Backend.init();
        forgeEventBus.addListener(FlwCommands::registerClientCommands);
        forgeEventBus.addListener(ProgramCompiler::invalidateAll);
        modEventBus.addListener(Contexts::flwInit);
        modEventBus.addListener(PartialModel::onModelRegistry);
        modEventBus.addListener(PartialModel::onModelBake);
        modEventBus.addListener(StitchedSprite::onTextureStitchPre);
        modEventBus.addListener(StitchedSprite::onTextureStitchPost);
        VanillaInstances.init();
        LOGGER.debug("Successfully loaded {}", (Object)PausedPartialTickAccessor.class.getName());
    }

    private static void setup(FMLCommonSetupEvent event) {
        ArgumentTypes.m_121601_((String)Flywheel.rl("engine").toString(), BackendTypeArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(BackendTypeArgument::getInstance));
    }

    public static ArtifactVersion getVersion() {
        return version;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }
}

