/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.api.IDungeonRegistry;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LogHelper;
import jeresources.util.LootTableHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class DungeonRegistryImpl
implements IDungeonRegistry {
    private static List<Tuple<String, String>> categoryMapping = new LinkedList<Tuple<String, String>>();
    private static Map<String, ResourceLocation> rawRegisters = new HashMap<String, ResourceLocation>();
    private static List<DungeonEntry> preppedRegisters = new LinkedList<DungeonEntry>();

    protected DungeonRegistryImpl() {
    }

    @Override
    public void registerCategory(@Nonnull String category, @Nonnull String localization) {
        categoryMapping.add((Tuple<String, String>)new Tuple((Object)category, (Object)localization));
    }

    @Override
    public void registerChest(@Nonnull String category, @Nonnull ResourceLocation tableLocation) {
        rawRegisters.put(category, tableLocation);
    }

    @Override
    public void registerChest(@Nonnull String category, @Nonnull LootTable lootTable) {
        try {
            preppedRegisters.add(new DungeonEntry(category, lootTable));
        }
        catch (Exception e) {
            LogHelper.debug("Bad dungeon chest registry for category %s", category);
        }
    }

    protected static void commit() {
        categoryMapping.forEach(t -> DungeonRegistry.addCategoryMapping((String)t.m_14418_(), (String)t.m_14419_()));
        preppedRegisters.forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
        LootTables manager = LootTableHelper.getLootTables();
        rawRegisters.entrySet().stream().map(entry -> {
            try {
                return new DungeonEntry((String)entry.getKey(), manager.m_79217_((ResourceLocation)entry.getValue()));
            }
            catch (Exception e) {
                LogHelper.debug("Bad dungeon chest registry for category %s", entry.getKey());
                return null;
            }
        }).forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
    }
}

