/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.worldgen.AllLayerPatterns;
import com.simibubi.create.foundation.worldgen.BiomeFilter;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.LayeredOreFeature;
import com.simibubi.create.foundation.worldgen.VanillaStyleOreFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllWorldFeatures {
    public static final Map<ResourceLocation, ConfigDrivenFeatureEntry> ENTRIES = new HashMap<ResourceLocation, ConfigDrivenFeatureEntry>();
    private static final BiomeFilter OVERWORLD_BIOMES = (r, b) -> b != Biome.BiomeCategory.NETHER && b != Biome.BiomeCategory.THEEND && b != Biome.BiomeCategory.NONE;
    private static final BiomeFilter NETHER_BIOMES = (r, b) -> b == Biome.BiomeCategory.NETHER;
    public static final ConfigDrivenFeatureEntry ZINC_ORE = AllWorldFeatures.register("zinc_ore", 12, 8.0f, OVERWORLD_BIOMES).between(-63, 70).withBlocks(Couple.create(AllBlocks.ZINC_ORE, AllBlocks.DEEPSLATE_ZINC_ORE));
    public static final ConfigDrivenFeatureEntry STRIATED_ORES_OVERWORLD = AllWorldFeatures.register("striated_ores_overworld", 32, 0.083333336f, OVERWORLD_BIOMES).between(-30, 70).withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE);
    public static final ConfigDrivenFeatureEntry STRIATED_ORES_NETHER = AllWorldFeatures.register("striated_ores_nether", 32, 0.083333336f, NETHER_BIOMES).between(40, 90).withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER);
    public static final int forcedUpdateVersion = 2;

    private static ConfigDrivenFeatureEntry register(String id, int clusterSize, float frequency, BiomeFilter biomeFilter) {
        ConfigDrivenFeatureEntry configDrivenFeatureEntry = new ConfigDrivenFeatureEntry(id, clusterSize, frequency);
        configDrivenFeatureEntry.biomeFilter = biomeFilter;
        ENTRIES.put(Create.asResource(id), configDrivenFeatureEntry);
        return configDrivenFeatureEntry;
    }

    public static void registerFeatures() {
        ENTRIES.entrySet().forEach(entry -> {
            String id = "create_" + ((ResourceLocation)entry.getKey()).m_135815_();
            ConfigDrivenFeatureEntry featureEntry = (ConfigDrivenFeatureEntry)entry.getValue();
            featureEntry.configuredFeature = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123861_, (String)id, featureEntry.factory.apply(featureEntry));
            featureEntry.placedFeature = BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_194653_, (String)id, (Object)new PlacedFeature(featureEntry.configuredFeature, (List)ImmutableList.of((Object)((Object)new ConfigDrivenDecorator(featureEntry.id)))));
        });
    }

    public static void reload(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        GenerationStep.Decoration decoStep = GenerationStep.Decoration.UNDERGROUND_ORES;
        ENTRIES.values().forEach(entry -> {
            ConfigDrivenFeatureEntry value = entry;
            if (value.biomeFilter.test(event.getName(), event.getCategory())) {
                generation.m_204201_(decoStep, value.placedFeature);
            }
        });
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder) {
        ENTRIES.values().forEach(entry -> {
            builder.push(entry.id);
            entry.addToConfig(builder);
            builder.pop();
        });
    }

    public static void register() {
    }

    public static void registerOreFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{VanillaStyleOreFeature.INSTANCE, LayeredOreFeature.INSTANCE});
    }

    public static void registerPlacementTypes() {
        ConfigDrivenDecorator.TYPE = (PlacementModifierType)Registry.m_122961_((Registry)Registry.f_194570_, (String)"create_config_driven", () -> ConfigDrivenDecorator.CODEC);
    }
}

