/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ValueBoxTransform {
    protected float scale = this.getScale();

    protected abstract Vec3 getLocalOffset(BlockState var1);

    protected abstract void rotate(BlockState var1, PoseStack var2);

    public boolean testHit(BlockState state, Vec3 localHit) {
        Vec3 offset = this.getLocalOffset(state);
        if (offset == null) {
            return false;
        }
        return localHit.m_82554_(offset) < (double)(this.scale / 2.0f);
    }

    public void transform(BlockState state, PoseStack ms) {
        Vec3 position = this.getLocalOffset(state);
        if (position == null) {
            return;
        }
        ms.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.rotate(state, ms);
        ms.m_85841_(this.scale, this.scale, this.scale);
    }

    public boolean shouldRender(BlockState state) {
        return state.m_60767_() != Material.f_76296_ && this.getLocalOffset(state) != null;
    }

    protected Vec3 rotateHorizontally(BlockState state, Vec3 vec) {
        float yRot = 0.0f;
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            yRot = AngleHelper.horizontalAngle((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            yRot = AngleHelper.horizontalAngle((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
        }
        return VecHelper.rotateCentered(vec, yRot, Direction.Axis.Y);
    }

    protected float getScale() {
        return 0.4f;
    }

    protected float getFontScale() {
        return 0.015625f;
    }

    public static abstract class Sided
    extends ValueBoxTransform {
        protected Direction direction = Direction.UP;

        public Sided fromSide(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Override
        protected Vec3 getLocalOffset(BlockState state) {
            Vec3 location = this.getSouthLocation();
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(this.getSide()), Direction.Axis.Y);
            location = VecHelper.rotateCentered(location, AngleHelper.verticalAngle(this.getSide()), Direction.Axis.X);
            return location;
        }

        protected abstract Vec3 getSouthLocation();

        @Override
        protected void rotate(BlockState state, PoseStack ms) {
            float yRot = AngleHelper.horizontalAngle(this.getSide()) + 180.0f;
            float xRot = this.getSide() == Direction.UP ? 90.0f : (this.getSide() == Direction.DOWN ? 270.0f : 0.0f);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)yRot)).rotateX((double)xRot);
        }

        @Override
        public boolean shouldRender(BlockState state) {
            return super.shouldRender(state) && this.isSideActive(state, this.getSide());
        }

        @Override
        public boolean testHit(BlockState state, Vec3 localHit) {
            return this.isSideActive(state, this.getSide()) && super.testHit(state, localHit);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return true;
        }

        public Direction getSide() {
            return this.direction;
        }
    }

    public static abstract class Dual
    extends ValueBoxTransform {
        protected boolean first;

        public Dual(boolean first) {
            this.first = first;
        }

        public boolean isFirst() {
            return this.first;
        }

        public static Pair<ValueBoxTransform, ValueBoxTransform> makeSlots(Function<Boolean, ? extends Dual> factory) {
            return Pair.of((Object)factory.apply(true), (Object)factory.apply(false));
        }

        @Override
        public boolean testHit(BlockState state, Vec3 localHit) {
            Vec3 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.m_82554_(offset) < (double)(this.scale / 3.5f);
        }
    }
}

