/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TunnelScenes {
    public static void andesite(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("andesite_tunnel", "Using Andesite Tunnels");
        scene.configureBasePlate(0, 0, 5);
        scene.world.cycleBlockProperty(util.grid.at(2, 1, 2), (Property<?>)BeltBlock.CASING);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(4, 1, 5, 4, 1, 3), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 0, 1, 2), Direction.SOUTH);
        scene.idle(10);
        Vector<ElementLink<WorldSectionElement>> tunnels = new Vector<ElementLink<WorldSectionElement>>(3);
        for (i = 0; i < 3; ++i) {
            tunnels.add(scene.world.showIndependentSection(util.select.position(1 + i, 2, 4), Direction.DOWN));
            scene.world.moveSection((ElementLink)tunnels.get(i), util.vector.of(0.0, 0.0, -2.0), 0);
            scene.idle(4);
        }
        for (i = 0; i < 3; ++i) {
            scene.world.cycleBlockProperty(util.grid.at(1 + i, 1, 2), (Property<?>)BeltBlock.CASING);
            scene.world.modifyTileNBT(util.select.position(1 + i, 1, 2), BeltTileEntity.class, nbt -> NBTHelper.writeEnum(nbt, "Casing", BeltTileEntity.CasingType.ANDESITE), true);
            scene.idle(4);
        }
        scene.overlay.showText(60).attachKeyFrame().pointAt(util.vector.topOf(util.grid.at(1, 2, 2))).placeNearTarget().text("Andesite Tunnels can be used to cover up your belts");
        scene.idle(70);
        for (i = 0; i < 3; ++i) {
            scene.world.cycleBlockProperty(util.grid.at(1 + i, 1, 2), (Property<?>)BeltBlock.CASING);
            scene.world.hideIndependentSection((ElementLink)tunnels.get(i), Direction.UP);
            scene.idle(4);
        }
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 0, 0, 1, 1), Direction.SOUTH);
        scene.idle(10);
        scene.world.showSection(util.select.position(2, 2, 2), Direction.DOWN);
        scene.idle(10);
        scene.world.cycleBlockProperty(util.grid.at(2, 1, 2), (Property<?>)BeltBlock.CASING);
        scene.overlay.showText(60).attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.NORTH)).placeNearTarget().text("Whenever an Andesite Tunnel has connections to the sides...");
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(util.grid.at(4, 1, 2)), Pointing.DOWN).withItem(new ItemStack((ItemLike)Items.f_151052_)), 20);
        scene.idle(7);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), Direction.UP, new ItemStack((ItemLike)Items.f_151052_, 64));
        scene.idle(40);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 0.0625f);
        scene.overlay.showText(80).attachKeyFrame().text("...they will split exactly one item off of any passing stacks").pointAt(util.vector.blockSurface(util.grid.at(2, 1, 0), Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.overlay.showText(80).text("The remainder will continue on its path").pointAt(util.vector.blockSurface(util.grid.at(0, 1, 2), Direction.UP)).placeNearTarget();
        scene.idle(90);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 16.0f);
    }

    public static void brass(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("brass_tunnel", "Using Brass Tunnels");
        scene.configureBasePlate(1, 0, 5);
        scene.world.cycleBlockProperty(util.grid.at(3, 1, 2), (Property<?>)BeltBlock.CASING);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(5, 1, 5, 5, 1, 3), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(5, 1, 2, 1, 1, 2), Direction.SOUTH);
        scene.idle(10);
        Vector<ElementLink<WorldSectionElement>> tunnels = new Vector<ElementLink<WorldSectionElement>>(3);
        for (i = 0; i < 3; ++i) {
            tunnels.add(scene.world.showIndependentSection(util.select.position(2 + i, 2, 4), Direction.DOWN));
            scene.world.moveSection((ElementLink)tunnels.get(i), util.vector.of(0.0, 0.0, -2.0), 0);
            scene.idle(4);
        }
        for (i = 0; i < 3; ++i) {
            scene.world.cycleBlockProperty(util.grid.at(2 + i, 1, 2), (Property<?>)BeltBlock.CASING);
            scene.world.modifyTileNBT(util.select.position(2 + i, 1, 2), BeltTileEntity.class, nbt -> NBTHelper.writeEnum(nbt, "Casing", BeltTileEntity.CasingType.BRASS), true);
            scene.idle(4);
        }
        scene.overlay.showText(60).attachKeyFrame().pointAt(util.vector.topOf(util.grid.at(2, 2, 2))).placeNearTarget().text("Brass Tunnels can be used to cover up your belts");
        scene.idle(70);
        for (i = 0; i < 3; ++i) {
            scene.world.cycleBlockProperty(util.grid.at(2 + i, 1, 2), (Property<?>)BeltBlock.CASING);
            scene.world.hideIndependentSection((ElementLink)tunnels.get(i), Direction.UP);
            scene.idle(4);
        }
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(3, 1, 0, 1, 1, 1), Direction.SOUTH);
        scene.idle(10);
        scene.world.showSection(util.select.position(3, 2, 2), Direction.DOWN);
        scene.idle(10);
        scene.world.cycleBlockProperty(util.grid.at(3, 1, 2), (Property<?>)BeltBlock.CASING);
        scene.idle(10);
        BlockPos tunnelPos = util.grid.at(3, 2, 2);
        for (Direction d : Iterate.horizontalDirections) {
            if (d == Direction.SOUTH) continue;
            Vec3 filter = TunnelScenes.getTunnelFilterVec(tunnelPos, d);
            scene.overlay.showFilterSlotInput(filter, 40);
            scene.idle(3);
        }
        scene.overlay.showText(60).attachKeyFrame().pointAt(TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.WEST)).placeNearTarget().text("Brass Tunnels have filter slots on each open side");
        scene.idle(70);
        scene.rotateCameraY(70.0f);
        scene.idle(20);
        Vec3 tunnelFilterVec = TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.EAST);
        scene.overlay.showFilterSlotInput(tunnelFilterVec, 40);
        scene.overlay.showText(60).attachKeyFrame().pointAt(tunnelFilterVec).placeNearTarget().text("Filters on inbound connections simply block non-matching items");
        ItemStack copper = new ItemStack((ItemLike)Items.f_151052_);
        Class<BrassTunnelTileEntity> tunnelClass = BrassTunnelTileEntity.class;
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.EAST, copper));
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec, Pointing.DOWN).withItem(copper), 30);
        ItemStack zinc = AllItems.ZINC_INGOT.asStack();
        scene.world.createItemOnBelt(util.grid.at(5, 1, 2), Direction.EAST, zinc);
        scene.idle(70);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), -2.0f);
        scene.idle(20);
        scene.rotateCameraY(-70.0f);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), -0.5f);
        scene.idle(20);
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.EAST, ItemStack.f_41583_));
        tunnelFilterVec = TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.NORTH);
        scene.overlay.showFilterSlotInput(tunnelFilterVec, 40);
        tunnelFilterVec = TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.WEST);
        scene.overlay.showFilterSlotInput(tunnelFilterVec, 40);
        scene.overlay.showText(60).attachKeyFrame().pointAt(tunnelFilterVec).placeNearTarget().text("Filters on outbound connections can be used to sort items by type");
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec, Pointing.LEFT).withItem(copper), 30);
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.WEST, copper));
        scene.idle(4);
        tunnelFilterVec = TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.NORTH);
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec, Pointing.RIGHT).withItem(zinc), 30);
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.NORTH, zinc));
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 1.5f);
        for (int i2 = 0; i2 < 6; ++i2) {
            scene.world.createItemOnBelt(util.grid.at(5, 1, 2), Direction.EAST, i2 % 2 == 0 ? zinc : copper);
            scene.idle(12);
        }
        scene.idle(30);
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.NORTH, ItemStack.f_41583_));
        scene.world.modifyTileEntity(tunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.WEST, ItemStack.f_41583_));
        scene.idle(10);
        Vec3 tunnelTop = util.vector.topOf(tunnelPos);
        scene.overlay.showControls(new InputWindowElement(tunnelTop, Pointing.DOWN).scroll().withWrench(), 80);
        scene.idle(7);
        scene.overlay.showCenteredScrollInput(tunnelPos, Direction.UP, 120);
        scene.overlay.showText(120).attachKeyFrame().pointAt(tunnelTop).placeNearTarget().text("Whenever a passing item has multiple valid exits, the distribution mode will decide how to handle it");
        for (int i3 = 0; i3 < 3; ++i3) {
            scene.idle(40);
            scene.world.createItemOnBelt(util.grid.at(5, 1, 2), Direction.EAST, AllItems.BRASS_INGOT.asStack(63));
        }
        scene.idle(30);
        scene.world.hideSection(util.select.position(3, 2, 2), Direction.UP);
        scene.idle(5);
        scene.world.hideSection(util.select.fromTo(5, 1, 2, 1, 1, 0), Direction.UP);
        scene.idle(15);
        ElementLink<WorldSectionElement> newBelt = scene.world.showIndependentSection(util.select.fromTo(3, 3, 2, 0, 3, 4).add(util.select.fromTo(5, 3, 3, 4, 3, 3)), Direction.DOWN);
        scene.world.moveSection(newBelt, util.vector.of(0.0, -2.0, -1.0), 0);
        scene.idle(15);
        for (int i4 = 0; i4 < 3; ++i4) {
            scene.idle(4);
            scene.world.showSectionAndMerge(util.select.position(3, 4, 2 + i4), Direction.DOWN, newBelt);
        }
        scene.overlay.showSelectionWithText(util.select.fromTo(3, 1, 1, 3, 2, 3), 80).attachKeyFrame().placeNearTarget().text("Brass Tunnels on parallel belts will form a group");
        scene.idle(90);
        ItemStack item1 = new ItemStack((ItemLike)Items.f_42619_);
        ItemStack item2 = new ItemStack((ItemLike)Items.f_42787_);
        ItemStack item3 = new ItemStack((ItemLike)Items.f_42780_);
        tunnelFilterVec = TunnelScenes.getTunnelFilterVec(tunnelPos, Direction.WEST);
        BlockPos newTunnelPos = tunnelPos.m_6630_(2).m_142128_();
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec.m_82520_(0.0, 0.0, -1.0), Pointing.RIGHT).withItem(item1), 20);
        scene.world.modifyTileEntity(newTunnelPos.m_142127_(), tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.WEST, item1));
        scene.idle(4);
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec, Pointing.DOWN).withItem(item2), 20);
        scene.world.modifyTileEntity(newTunnelPos, tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.WEST, item2));
        scene.idle(4);
        scene.overlay.showControls(new InputWindowElement(tunnelFilterVec.m_82520_(0.0, 0.0, 1.0), Pointing.LEFT).withItem(item3), 20);
        scene.world.modifyTileEntity(newTunnelPos.m_142128_(), tunnelClass, te -> ((FilteringBehaviour)te.getBehaviour(SidedFilteringBehaviour.TYPE)).setFilter(Direction.WEST, item3));
        scene.idle(30);
        scene.overlay.showText(80).pointAt(tunnelTop).placeNearTarget().text("Incoming Items will now be distributed across all connected exits");
        scene.idle(90);
        BlockPos beltPos = util.grid.at(5, 3, 3);
        Vec3 m = util.vector.of(0.0, 0.1, 0.0);
        Vec3 spawn = util.vector.centerOf(util.grid.at(5, 3, 2));
        scene.world.createItemEntity(spawn, m, item1);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.UP, item1);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.world.createItemEntity(spawn, m, item2);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.UP, item2);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.world.createItemEntity(spawn, m, item3);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.UP, item3);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.idle(50);
        scene.world.showSectionAndMerge(util.select.position(3, 5, 2), Direction.DOWN, newBelt);
        scene.overlay.showText(80).pointAt(util.vector.blockSurface(tunnelPos.m_7494_().m_142127_(), Direction.WEST)).placeNearTarget().text("For this, items can also be inserted into the Tunnel block directly");
        scene.idle(20);
        beltPos = util.grid.at(3, 3, 3);
        spawn = util.vector.centerOf(util.grid.at(3, 5, 1));
        scene.world.createItemEntity(spawn, m, item1);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, item1);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.world.createItemEntity(spawn, m, item2);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, item2);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.world.createItemEntity(spawn, m, item3);
        scene.idle(12);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, item3);
        scene.world.modifyEntities(ItemEntity.class, Entity::m_146870_);
        scene.idle(30);
    }

    protected static Vec3 getTunnelFilterVec(BlockPos pos, Direction d) {
        return VecHelper.getCenterOf((Vec3i)pos).m_82549_(Vec3.m_82528_((Vec3i)d.m_122436_()).m_82490_(0.5)).m_82520_(0.0, 0.3, 0.0);
    }

    public static void brassModes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("brass_tunnel_modes", "Distribution Modes of the Brass Tunnel");
        scene.configureBasePlate(0, 1, 5);
        BlockState barrier = Blocks.f_50375_.m_49966_();
        scene.world.setBlock(util.grid.at(1, 1, 0), barrier, false);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 1, 1, 5, 1, 5).add(util.select.fromTo(3, 2, 5, 1, 2, 5)), Direction.DOWN);
        scene.idle(10);
        for (int i = 0; i < 3; ++i) {
            scene.world.showSection(util.select.position(3 - i, 2, 3), Direction.DOWN);
            scene.idle(4);
        }
        Vec3 tunnelTop = util.vector.topOf(util.grid.at(2, 2, 3));
        scene.overlay.showControls(new InputWindowElement(tunnelTop, Pointing.DOWN).scroll().withWrench(), 80);
        scene.idle(7);
        scene.overlay.showCenteredScrollInput(util.grid.at(2, 2, 3), Direction.UP, 120);
        scene.overlay.showText(120).attachKeyFrame().pointAt(tunnelTop).placeNearTarget().text("Using a Wrench, the distribution behaviour of Brass Tunnels can be configured");
        scene.idle(130);
        Class<BrassTunnelTileEntity> tunnelClass = BrassTunnelTileEntity.class;
        ElementLink<WorldSectionElement> blockage = scene.world.showIndependentSection(util.select.position(4, 1, 0), Direction.UP);
        scene.world.moveSection(blockage, util.vector.of(-3.0, 0.0, 0.0), 0);
        Vec3 modeVec = util.vector.of(4.0, 2.5, 3.0);
        scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_SPLIT), 140);
        ElementLink<WorldSectionElement> blockage2 = null;
        for (int i = 0; i < 32; ++i) {
            if (i < 30) {
                scene.world.createItemOnBelt(util.grid.at(1, 1, 5), Direction.EAST, new ItemStack((ItemLike)Items.f_42452_, 12));
            }
            scene.idle(i > 8 ? 30 : 40);
            if (i == 0) {
                scene.overlay.showText(80).attachKeyFrame().pointAt(tunnelTop).placeNearTarget().text("'Split' will attempt to distribute the stack evenly between available outputs");
            }
            if (i == 2) {
                scene.overlay.showText(60).text("If an output is unable to take more items, it will be skipped").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.GREEN);
            }
            if (i == 4) {
                scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_FORCED_SPLIT), 140);
                scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.FORCED_SPLIT.ordinal()));
            }
            if (i == 5) {
                scene.overlay.showText(80).attachKeyFrame().text("'Forced Split' will never skip outputs, and instead wait until they are free").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.RED);
                scene.idle(60);
                scene.world.moveSection(blockage, util.vector.of(-1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(1, 1, 0), Blocks.f_50016_.m_49966_(), false);
                scene.world.multiplyKineticSpeed(util.select.everywhere(), 1.5f);
            }
            if (i == 7) {
                scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.ROUND_ROBIN.ordinal()));
                scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_ROUND_ROBIN), 140);
                scene.overlay.showText(80).attachKeyFrame().pointAt(tunnelTop).placeNearTarget().text("'Round Robin' keeps stacks whole, and cycles through outputs iteratively");
            }
            if (i == 7) {
                scene.world.moveSection(blockage, util.vector.of(1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(1, 1, 0), barrier, false);
            }
            if (i == 13) {
                scene.overlay.showText(60).text("Once Again, if an output is unable to take more items, it will be skipped").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.UP)).colored(PonderPalette.GREEN);
            }
            if (i == 15) {
                scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_FORCED_ROUND_ROBIN), 140);
                scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.FORCED_ROUND_ROBIN.ordinal()));
            }
            if (i == 16) {
                scene.overlay.showText(50).attachKeyFrame().placeNearTarget().text("'Forced Round Robin' never skips outputs").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.UP)).colored(PonderPalette.RED);
                scene.idle(30);
                scene.world.moveSection(blockage, util.vector.of(-1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(1, 1, 0), Blocks.f_50016_.m_49966_(), false);
            }
            if (i == 19) {
                scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_PREFER_NEAREST), 140);
                scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.PREFER_NEAREST.ordinal()));
                scene.world.moveSection(blockage, util.vector.of(1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(1, 1, 0), barrier, false);
                scene.overlay.showText(70).attachKeyFrame().text("'Prefer Nearest' prioritizes the outputs closest to the items' input location").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.GREEN);
            }
            if (i == 21) {
                scene.world.setBlock(util.grid.at(2, 1, 0), Blocks.f_50375_.m_49966_(), false);
                blockage2 = scene.world.showIndependentSection(util.select.position(4, 1, 0), Direction.UP);
                scene.world.moveSection(blockage2, util.vector.of(-2.0, 0.0, 0.0), 0);
            }
            if (i == 25) {
                scene.world.hideIndependentSection(blockage, Direction.DOWN);
                scene.world.setBlock(util.grid.at(1, 1, 0), Blocks.f_50016_.m_49966_(), false);
                scene.world.hideIndependentSection(blockage2, Direction.DOWN);
                scene.world.setBlock(util.grid.at(2, 1, 0), Blocks.f_50016_.m_49966_(), false);
            }
            if (i == 26) {
                scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_RANDOMIZE), 140);
                scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.RANDOMIZE.ordinal()));
            }
            if (i != 27) continue;
            scene.overlay.showText(70).attachKeyFrame().text("'Randomize' will distribute whole stacks to randomly picked outputs").pointAt(tunnelTop).placeNearTarget();
        }
        scene.world.hideSection(util.select.fromTo(3, 2, 5, 1, 2, 5), Direction.UP);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(modeVec, Pointing.RIGHT).showing(AllIcons.I_TUNNEL_SYNCHRONIZE), 140);
        scene.world.modifyTileEntity(util.grid.at(1, 2, 3), tunnelClass, te -> ((ScrollValueBehaviour)te.getBehaviour(ScrollOptionBehaviour.TYPE)).setValue(BrassTunnelTileEntity.SelectionMode.SYNCHRONIZE.ordinal()));
        scene.idle(30);
        scene.overlay.showText(70).attachKeyFrame().text("'Synchronize Inputs' is a unique setting for Brass Tunnels").pointAt(tunnelTop).placeNearTarget();
        ItemStack item1 = new ItemStack((ItemLike)Items.f_42619_);
        ItemStack item2 = new ItemStack((ItemLike)Items.f_42787_);
        ItemStack item3 = AllItems.POLISHED_ROSE_QUARTZ.asStack();
        scene.world.createItemOnBelt(util.grid.at(3, 1, 4), Direction.UP, item1);
        scene.world.createItemOnBelt(util.grid.at(2, 1, 4), Direction.UP, item2);
        scene.world.createItemOnBelt(util.grid.at(3, 1, 5), Direction.SOUTH, item1);
        scene.world.createItemOnBelt(util.grid.at(2, 1, 5), Direction.SOUTH, item2);
        scene.idle(80);
        scene.world.createItemOnBelt(util.grid.at(2, 1, 5), Direction.SOUTH, item2);
        scene.rotateCameraY(-90.0f);
        scene.idle(20);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 0.5f);
        scene.overlay.showText(70).text("Items are only allowed past if every tunnel in the group has one waiting").pointAt(util.vector.blockSurface(util.grid.at(2, 1, 4), Direction.UP)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(60);
        scene.world.createItemOnBelt(util.grid.at(1, 1, 5), Direction.SOUTH, item3);
        scene.idle(90);
        scene.rotateCameraY(90.0f);
        scene.overlay.showText(100).text("This ensures that all affected belts supply items at the same rate").pointAt(util.vector.blockSurface(util.grid.at(1, 2, 3), Direction.WEST)).placeNearTarget().colored(PonderPalette.GREEN);
    }
}

