/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.block.BlockStressDefaults;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.Couple;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class CStress
extends ConfigBase
implements BlockStressValues.IStressValueProvider {
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    @Override
    protected void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"", Comments.su, Comments.impact}).push("impact");
        BlockStressDefaults.DEFAULT_IMPACTS.forEach((r, i) -> {
            if (r.m_135827_().equals("create")) {
                this.getImpacts().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.m_135815_(), i));
            }
        });
        builder.pop();
        builder.comment(new String[]{"", Comments.su, Comments.capacity}).push("capacity");
        BlockStressDefaults.DEFAULT_CAPACITIES.forEach((r, i) -> {
            if (r.m_135827_().equals("create")) {
                this.getCapacities().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.m_135815_(), i));
            }
        });
        builder.pop();
    }

    @Override
    public double getImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = block.getRegistryName();
        ForgeConfigSpec.ConfigValue<Double> value = this.getImpacts().get(key);
        if (value != null) {
            return (Double)value.get();
        }
        return 0.0;
    }

    @Override
    public double getCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = block.getRegistryName();
        ForgeConfigSpec.ConfigValue<Double> value = this.getCapacities().get(key);
        if (value != null) {
            return (Double)value.get();
        }
        return 0.0;
    }

    @Override
    public Couple<Integer> getGeneratedRPM(Block block) {
        ResourceLocation key = (block = this.redirectValues(block)).getRegistryName();
        Supplier<Couple<Integer>> supplier = BlockStressDefaults.GENERATOR_SPEEDS.get(key);
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    @Override
    public boolean hasImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = block.getRegistryName();
        return this.getImpacts().containsKey(key);
    }

    @Override
    public boolean hasCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = block.getRegistryName();
        return this.getCapacities().containsKey(key);
    }

    protected Block redirectValues(Block block) {
        return block;
    }

    @Override
    public String getName() {
        return "stressValues.v2";
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getImpacts() {
        return this.impacts;
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getCapacities() {
        return this.capacities;
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        private Comments() {
        }
    }
}

