/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.util.Color;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.tools.BlueprintOverlayRenderer;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlockItem;
import com.simibubi.create.content.logistics.trains.track.TrackPaver;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class TrackPlacement {
    public static PlacementInfo cached;
    static BlockPos hoveringPos;
    static boolean hoveringMaxed;
    static int hoveringAngle;
    static ItemStack lastItem;
    static LerpedFloat animation;
    static int lastLineCount;
    static BlockPos hintPos;
    static int hintAngle;
    static Couple<List<BlockPos>> hints;

    public static PlacementInfo tryConnect(Level level, Player player, BlockPos pos2, BlockState state2, ItemStack stack, boolean girder, boolean maximiseTurn) {
        double[] sTest;
        boolean slope;
        double[] intersect;
        ITrackBlock track;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis;
        Vec3 lookVec = player.m_20154_();
        int lookAngle = (int)(22.5 + (double)(AngleHelper.deg(Mth.m_14136_((double)lookVec.f_82481_, (double)lookVec.f_82479_)) % 360.0f)) / 8;
        if (level.f_46443_ && cached != null && pos2.equals((Object)hoveringPos) && stack.equals(lastItem) && hoveringMaxed == maximiseTurn && lookAngle == hoveringAngle) {
            return cached;
        }
        PlacementInfo info = new PlacementInfo();
        hoveringMaxed = maximiseTurn;
        hoveringAngle = lookAngle;
        hoveringPos = pos2;
        lastItem = stack;
        cached = info;
        Vec3 axis2 = nearestTrackAxis.getFirst().m_82490_((nearestTrackAxis = (track = (ITrackBlock)state2.m_60734_()).getNearestTrackAxis((BlockGetter)level, pos2, state2, lookVec)).getSecond() == Direction.AxisDirection.POSITIVE ? -1.0 : 1.0);
        Vec3 normal2 = track.getUpNormal((BlockGetter)level, pos2, state2).m_82541_();
        Vec3 normedAxis2 = axis2.m_82541_();
        Vec3 end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
        CompoundTag itemTag = stack.m_41783_();
        CompoundTag selectionTag = itemTag.m_128469_("ConnectingFrom");
        BlockPos pos1 = NbtUtils.m_129239_((CompoundTag)selectionTag.m_128469_("Pos"));
        Vec3 axis1 = VecHelper.readNBT(selectionTag.m_128437_("Axis", 6));
        Vec3 normedAxis1 = axis1.m_82541_();
        Vec3 end1 = VecHelper.readNBT(selectionTag.m_128437_("End", 6));
        Vec3 normal1 = VecHelper.readNBT(selectionTag.m_128437_("Normal", 6));
        boolean front1 = selectionTag.m_128471_("Front");
        BlockState state1 = level.m_8055_(pos1);
        if (level.f_46443_) {
            info.end1 = end1;
            info.end2 = end2;
            info.normal1 = normal1;
            info.normal2 = normal2;
            info.axis1 = axis1;
            info.axis2 = axis2;
        }
        if (pos1.equals((Object)pos2)) {
            return info.withMessage("second_point");
        }
        if (pos1.m_123331_((Vec3i)pos2) > 1024.0) {
            return info.withMessage("too_far").tooJumbly();
        }
        if (!state1.m_61138_((Property)TrackBlock.HAS_TE)) {
            return info.withMessage("original_missing");
        }
        if (axis1.m_82526_(end2.m_82546_(end1)) < 0.0) {
            axis1 = axis1.m_82490_(-1.0);
            normedAxis1 = normedAxis1.m_82490_(-1.0);
            front1 = !front1;
            end1 = track.getCurveStart((BlockGetter)level, pos1, state1, axis1);
            if (level.f_46443_) {
                info.end1 = end1;
                info.axis1 = axis1;
            }
        }
        boolean parallel = (intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, Direction.Axis.Y)) == null;
        boolean skipCurve = false;
        if (parallel && normedAxis1.m_82526_(normedAxis2) > 0.0 || !parallel && (intersect[0] < 0.0 || intersect[1] < 0.0)) {
            axis2 = axis2.m_82490_(-1.0);
            normedAxis2 = normedAxis2.m_82490_(-1.0);
            end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
            if (level.f_46443_) {
                info.end2 = end2;
                info.axis2 = axis2;
            }
        }
        Vec3 cross2 = normedAxis2.m_82537_(new Vec3(0.0, 1.0, 0.0));
        double a1 = Mth.m_14136_((double)normedAxis2.f_82481_, (double)normedAxis2.f_82479_);
        double a2 = Mth.m_14136_((double)normedAxis1.f_82481_, (double)normedAxis1.f_82479_);
        double angle = a1 - a2;
        double ascend = end2.m_82546_((Vec3)end1).f_82480_;
        double absAscend = Math.abs(ascend);
        boolean bl = slope = !normal1.equals((Object)normal2);
        if (level.f_46443_) {
            Vec3 offset1 = axis1.m_82490_((double)info.end1Extent);
            Vec3 offset2 = axis2.m_82490_((double)info.end2Extent);
            BlockPos targetPos1 = pos1.m_142022_(offset1.f_82479_, offset1.f_82480_, offset1.f_82481_);
            BlockPos targetPos2 = pos2.m_142022_(offset2.f_82479_, offset2.f_82480_, offset2.f_82481_);
            info.curve = new BezierConnection(Couple.create(targetPos1, targetPos2), Couple.create(end1.m_82549_(offset1), end2.m_82549_(offset2)), Couple.create(normedAxis1, normedAxis2), Couple.create(normal1, normal2), true, girder);
        }
        double dist = 0.0;
        if (parallel && (sTest = VecHelper.intersect(end1, end2, normedAxis1, cross2, Direction.Axis.Y)) != null) {
            double t = Math.abs(sTest[0]);
            double u = Math.abs(sTest[1]);
            skipCurve = Mth.m_14082_((double)u, (double)0.0);
            if (!skipCurve && sTest[0] < 0.0) {
                return info.withMessage("perpendicular").tooJumbly();
            }
            if (skipCurve) {
                dist = VecHelper.getCenterOf((Vec3i)pos1).m_82554_(VecHelper.getCenterOf((Vec3i)pos2));
                info.end1Extent = (int)Math.round((dist + 1.0) / axis1.m_82553_());
            } else {
                double targetT;
                if (!Mth.m_14082_((double)ascend, (double)0.0)) {
                    return info.withMessage("ascending_s_curve");
                }
                double d = targetT = u <= 1.0 ? 3.0 : u * 2.0;
                if (t < targetT) {
                    return info.withMessage("too_sharp");
                }
                if (t > targetT) {
                    int correction = (int)((t - targetT) / axis1.m_82553_());
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    int n = info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
            }
        }
        if (slope) {
            double dist2;
            if (!skipCurve) {
                return info.withMessage("slope_turn");
            }
            if (Mth.m_14082_((double)normal1.m_82526_(normal2), (double)0.0)) {
                return info.withMessage("opposing_slopes");
            }
            if ((axis1.f_82480_ < 0.0 || axis2.f_82480_ > 0.0) && ascend > 0.0) {
                return info.withMessage("leave_slope_ascending");
            }
            if ((axis1.f_82480_ > 0.0 || axis2.f_82480_ < 0.0) && ascend < 0.0) {
                return info.withMessage("leave_slope_descending");
            }
            skipCurve = false;
            info.end1Extent = 0;
            info.end2Extent = 0;
            Direction.Axis plane = Mth.m_14082_((double)axis1.f_82479_, (double)0.0) ? Direction.Axis.X : Direction.Axis.Z;
            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, plane);
            double dist1 = Math.abs(intersect[0] / axis1.m_82553_());
            if (dist1 > (dist2 = Math.abs(intersect[1] / axis2.m_82553_()))) {
                info.end1Extent = (int)Math.round(dist1 - dist2);
            }
            if (dist2 > dist1) {
                info.end2Extent = (int)Math.round(dist2 - dist1);
            }
            double turnSize = Math.min(dist1, dist2);
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            if (turnSize < 2.0) {
                return info.withMessage("too_sharp");
            }
            if (turnSize > 2.0 && !maximiseTurn) {
                info.end1Extent = (int)((double)info.end1Extent + (turnSize - 2.0));
                info.end2Extent = (int)((double)info.end2Extent + (turnSize - 2.0));
                turnSize = 2.0;
            }
        }
        if (skipCurve && !Mth.m_14082_((double)ascend, (double)0.0)) {
            int hDistance = info.end1Extent;
            if (axis1.f_82480_ == 0.0 || !Mth.m_14082_((double)(absAscend + 1.0), (double)(dist / axis1.m_82553_()))) {
                if (axis1.f_82480_ != 0.0 && axis1.f_82480_ == -axis2.f_82480_) {
                    return info.withMessage("ascending_s_curve");
                }
                info.end1Extent = 0;
                double minHDistance = Math.max(absAscend < 4.0 ? absAscend * 4.0 : absAscend * 3.0, 6.0) / axis1.m_82553_();
                if ((double)hDistance < minHDistance) {
                    return info.withMessage("too_steep");
                }
                if ((double)hDistance > minHDistance) {
                    int correction = (int)((double)hDistance - minHDistance);
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
                skipCurve = false;
            }
        }
        if (!parallel) {
            boolean ninety;
            float absAngle = Math.abs(AngleHelper.deg(angle));
            if (absAngle < 60.0f || absAngle > 300.0f) {
                return info.withMessage("turn_90").tooJumbly();
            }
            intersect = VecHelper.intersect(end1, end2, normedAxis1, normedAxis2, Direction.Axis.Y);
            double dist1 = Math.abs(intersect[0]);
            double dist2 = Math.abs(intersect[1]);
            float ex1 = 0.0f;
            float ex2 = 0.0f;
            if (dist1 > dist2) {
                ex1 = (float)((dist1 - dist2) / axis1.m_82553_());
            }
            if (dist2 > dist1) {
                ex2 = (float)((dist2 - dist1) / axis2.m_82553_());
            }
            double turnSize = Math.min(dist1, dist2) - 0.1;
            boolean bl2 = ninety = (absAngle + 0.25f) % 90.0f < 1.0f;
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            double minTurnSize = ninety ? 7.0 : 3.25;
            double turnSizeToFitAscend = minTurnSize + (ninety ? Math.max(0.0, absAscend - 3.0) * 2.0 : Math.max(0.0, absAscend - 1.5) * 1.5);
            if (turnSize < minTurnSize) {
                return info.withMessage("too_sharp");
            }
            if (turnSize < turnSizeToFitAscend) {
                return info.withMessage("too_steep");
            }
            if (!maximiseTurn) {
                ex1 = (float)((double)ex1 + (turnSize - turnSizeToFitAscend) / axis1.m_82553_());
                ex2 = (float)((double)ex2 + (turnSize - turnSizeToFitAscend) / axis2.m_82553_());
            }
            info.end1Extent = Mth.m_14143_((float)ex1);
            info.end2Extent = Mth.m_14143_((float)ex2);
            turnSize = turnSizeToFitAscend;
        }
        Vec3 offset1 = axis1.m_82490_((double)info.end1Extent);
        Vec3 offset2 = axis2.m_82490_((double)info.end2Extent);
        BlockPos targetPos1 = pos1.m_142022_(offset1.f_82479_, offset1.f_82480_, offset1.f_82481_);
        BlockPos targetPos2 = pos2.m_142022_(offset2.f_82479_, offset2.f_82480_, offset2.f_82481_);
        info.curve = skipCurve ? null : new BezierConnection(Couple.create(targetPos1, targetPos2), Couple.create(end1.m_82549_(offset1), end2.m_82549_(offset2)), Couple.create(normedAxis1, normedAxis2), Couple.create(normal1, normal2), true, girder);
        info.valid = true;
        info.pos1 = pos1;
        info.pos2 = pos2;
        info.axis1 = axis1;
        info.axis2 = axis2;
        TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, true);
        ItemStack offhandItem = player.m_21206_().m_41777_();
        boolean shouldPave = offhandItem.m_41720_() instanceof BlockItem;
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.m_41720_();
            TrackPlacement.paveTracks(level, info, paveItem, true);
            info.hasRequiredPavement = true;
        }
        info.hasRequiredTracks = true;
        if (!player.m_7500_()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (level.f_46443_ && !simulate) break;
                int tracks = info.requiredTracks;
                int pavement = info.requiredPavement;
                int foundTracks = 0;
                int foundPavement = 0;
                Inventory inv = player.m_150109_();
                int size = inv.f_35974_.size();
                for (int j = 0; j <= size + 1; ++j) {
                    boolean offhand;
                    int i = j;
                    boolean bl3 = offhand = j == size + 1;
                    if (j == size) {
                        i = inv.f_35977_;
                    } else if (offhand) {
                        i = 0;
                    } else if (j == inv.f_35977_) continue;
                    ItemStack stackInSlot = (ItemStack)(offhand ? inv.f_35976_ : inv.f_35974_).get(i);
                    boolean isTrack = AllBlocks.TRACK.isIn(stackInSlot);
                    if (!isTrack && (!shouldPave || offhandItem.m_41720_() != stackInSlot.m_41720_()) || (isTrack ? foundTracks >= tracks : foundPavement >= pavement)) continue;
                    int count = stackInSlot.m_41613_();
                    if (!simulate) {
                        int remainingItems = count - Math.min(isTrack ? tracks - foundTracks : pavement - foundPavement, count);
                        if (i == inv.f_35977_) {
                            stackInSlot.m_41751_(null);
                        }
                        ItemStack newItem = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingItems);
                        if (offhand) {
                            player.m_21008_(InteractionHand.OFF_HAND, newItem);
                        } else {
                            inv.m_6836_(i, newItem);
                        }
                    }
                    if (isTrack) {
                        foundTracks += count;
                        continue;
                    }
                    foundPavement += count;
                }
                if (simulate && foundTracks < tracks) {
                    info.valid = false;
                    info.tooJumbly();
                    info.hasRequiredTracks = false;
                    return info.withMessage("not_enough_tracks");
                }
                if (!simulate || foundPavement >= pavement) continue;
                info.valid = false;
                info.tooJumbly();
                info.hasRequiredPavement = false;
                return info.withMessage("not_enough_pavement");
            }
        }
        if (level.m_5776_()) {
            return info;
        }
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.m_41720_();
            TrackPlacement.paveTracks(level, info, paveItem, false);
        }
        if (info.curve != null && info.curve.getLength() > 29.0) {
            AllAdvancements.LONG_BEND.awardTo(player);
        }
        return TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, false);
    }

    private static void paveTracks(Level level, PlacementInfo info, BlockItem blockItem, boolean simulate) {
        Block block = blockItem.m_40614_();
        info.requiredPavement = 0;
        if (block == null || block instanceof EntityBlock || block.m_49966_().m_60812_((BlockGetter)level, info.pos1).m_83281_()) {
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (boolean first : Iterate.trueAndFalse) {
            int extent = (first ? info.end1Extent : info.end2Extent) + (info.curve != null ? 1 : 0);
            Vec3 axis = first ? info.axis1 : info.axis2;
            BlockPos pavePos = first ? info.pos1 : info.pos2;
            info.requiredPavement += TrackPaver.paveStraight(level, pavePos.m_7495_(), axis, extent, block, simulate, visited);
        }
        if (info.curve != null) {
            info.requiredPavement += TrackPaver.paveCurve(level, info.curve, block, simulate, visited);
        }
    }

    private static PlacementInfo placeTracks(Level level, PlacementInfo info, BlockState state1, BlockState state2, BlockPos targetPos1, BlockPos targetPos2, boolean simulate) {
        info.requiredTracks = 0;
        for (boolean first : Iterate.trueAndFalse) {
            BlockState state;
            int extent = first ? info.end1Extent : info.end2Extent;
            Vec3 axis = first ? info.axis1 : info.axis2;
            BlockPos pos = first ? info.pos1 : info.pos2;
            BlockState blockState = state = first ? state1 : state2;
            if (state.m_61138_((Property)TrackBlock.HAS_TE) && !simulate) {
                state = (BlockState)state.m_61124_((Property)TrackBlock.HAS_TE, (Comparable)Boolean.valueOf(false));
            }
            switch ((TrackShape)((Object)state.m_61143_(TrackBlock.SHAPE))) {
                case TE: 
                case TW: {
                    state = (BlockState)state.m_61124_(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.XO));
                    break;
                }
                case TN: 
                case TS: {
                    state = (BlockState)state.m_61124_(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.ZO));
                    break;
                }
            }
            for (int i = 0; i < (info.curve != null ? extent + 1 : extent); ++i) {
                Vec3 offset = axis.m_82490_((double)i);
                BlockPos offsetPos = pos.m_142022_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                BlockState stateAtPos = level.m_8055_(offsetPos);
                BlockState toPlace = state;
                boolean canPlace = stateAtPos.m_60767_().m_76336_();
                if (canPlace) {
                    ++info.requiredTracks;
                }
                if (simulate) continue;
                Block block = stateAtPos.m_60734_();
                if (block instanceof ITrackBlock) {
                    ITrackBlock trackAtPos = (ITrackBlock)block;
                    toPlace = trackAtPos.overlay((BlockGetter)level, offsetPos, stateAtPos, toPlace);
                    canPlace = true;
                }
                if (!canPlace) continue;
                level.m_7731_(offsetPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, toPlace, offsetPos), 3);
            }
        }
        if (info.curve == null) {
            return info;
        }
        if (!simulate) {
            BlockState stateAtPos = level.m_8055_(targetPos1);
            level.m_7731_(targetPos1, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)(stateAtPos.m_60734_() == state1.m_60734_() ? stateAtPos : state1).m_61124_((Property)TrackBlock.HAS_TE, (Comparable)Boolean.valueOf(true)), targetPos1), 3);
            stateAtPos = level.m_8055_(targetPos2);
            level.m_7731_(targetPos2, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)(stateAtPos.m_60734_() == state2.m_60734_() ? stateAtPos : state2).m_61124_((Property)TrackBlock.HAS_TE, (Comparable)Boolean.valueOf(true)), targetPos2), 3);
        }
        BlockEntity te1 = level.m_7702_(targetPos1);
        BlockEntity te2 = level.m_7702_(targetPos2);
        int requiredTracksForTurn = (info.curve.getSegmentCount() + 1) / 2;
        if (!(te1 instanceof TrackTileEntity) || !(te2 instanceof TrackTileEntity)) {
            info.requiredTracks += requiredTracksForTurn;
            return info;
        }
        TrackTileEntity tte1 = (TrackTileEntity)te1;
        TrackTileEntity tte2 = (TrackTileEntity)te2;
        if (!tte1.getConnections().containsKey(tte2.m_58899_())) {
            info.requiredTracks += requiredTracksForTurn;
        }
        if (simulate) {
            return info;
        }
        tte1.addConnection(info.curve);
        tte2.addConnection(info.curve.secondary());
        return info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        int i;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21205_();
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null) {
            return;
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!AllBlocks.TRACK.isIn(stack)) {
            stack = player.m_21206_();
            hand = InteractionHand.OFF_HAND;
            if (!AllBlocks.TRACK.isIn(stack)) {
                return;
            }
        }
        if (!stack.m_41790_()) {
            return;
        }
        TrackBlockItem blockItem = (TrackBlockItem)stack.m_41720_();
        Level level = player.f_19853_;
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.m_82425_();
        BlockState hitState = level.m_8055_(pos);
        if (!(hitState.m_60734_() instanceof TrackBlock) && !hitState.m_60767_().m_76336_()) {
            pos = pos.m_142300_(bhr.m_82434_());
            hitState = blockItem.getPlacementState(new UseOnContext((Player)player, hand, bhr));
            if (hitState == null) {
                return;
            }
        }
        if (!(hitState.m_60734_() instanceof TrackBlock)) {
            return;
        }
        boolean maxTurns = Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
        PlacementInfo info = TrackPlacement.tryConnect(level, (Player)player, pos, hitState, stack, false, maxTurns);
        if (!(player.m_7500_() || !info.valid && info.hasRequiredTracks && info.hasRequiredPavement)) {
            BlueprintOverlayRenderer.displayTrackRequirements(info, player.m_21206_());
        }
        if (info.valid) {
            player.m_5661_((Component)Lang.translateDirect("track.valid_connection", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
        } else if (info.message != null) {
            player.m_5661_((Component)Lang.translateDirect(info.message, new Object[0]).m_130940_(info.message.equals("track.second_point") ? ChatFormatting.WHITE : ChatFormatting.RED), true);
        }
        if (bhr.m_82434_() == Direction.UP) {
            Vec3 lookVec = player.m_20154_();
            int lookAngle = (int)(22.5 + (double)(AngleHelper.deg(Mth.m_14136_((double)lookVec.f_82481_, (double)lookVec.f_82479_)) % 360.0f)) / 8;
            if (!pos.equals((Object)hintPos) || lookAngle != hintAngle) {
                hints = Couple.create(ArrayList::new);
                hintAngle = lookAngle;
                hintPos = pos;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        BlockPos offset = pos.m_142082_(xOffset, 0, zOffset);
                        PlacementInfo adjInfo = TrackPlacement.tryConnect(level, (Player)player, offset, hitState, stack, false, maxTurns);
                        hints.get(adjInfo.valid).add(offset.m_7495_());
                    }
                }
            }
            if (hints != null && !hints.either(Collection::isEmpty)) {
                CreateClient.OUTLINER.showCluster("track_valid", (Iterable)hints.getFirst()).withFaceTexture(AllSpecialTextures.THIN_CHECKERED).colored(9817409).lineWidth(0.0f);
                CreateClient.OUTLINER.showCluster("track_invalid", (Iterable)hints.getSecond()).withFaceTexture(AllSpecialTextures.THIN_CHECKERED).colored(15359019).lineWidth(0.0f);
            }
        }
        animation.chase(info.valid ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        animation.tickChaser();
        if (!info.valid) {
            info.end1Extent = 0;
            info.end2Extent = 0;
        }
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        Vec3 up = new Vec3(0.0, 0.25, 0.0);
        Vec3 v1 = info.end1;
        Vec3 a1 = info.axis1.m_82541_();
        Vec3 n1 = info.normal1.m_82537_(a1).m_82490_(0.9375);
        Vec3 o1 = a1.m_82490_(0.125);
        Vec3 ex1 = a1.m_82490_((double)(info.end1Extent - (info.curve == null && info.end1Extent > 0 ? 2 : 0)) * info.axis1.m_82553_());
        TrackPlacement.line(1, v1.m_82549_(n1).m_82549_(up), o1, ex1);
        TrackPlacement.line(2, v1.m_82546_(n1).m_82549_(up), o1, ex1);
        Vec3 v2 = info.end2;
        Vec3 a2 = info.axis2.m_82541_();
        Vec3 n2 = info.normal2.m_82537_(a2).m_82490_(0.9375);
        Vec3 o2 = a2.m_82490_(0.125);
        Vec3 ex2 = a2.m_82490_((double)info.end2Extent * info.axis2.m_82553_());
        TrackPlacement.line(3, v2.m_82549_(n2).m_82549_(up), o2, ex2);
        TrackPlacement.line(4, v2.m_82546_(n2).m_82549_(up), o2, ex2);
        BezierConnection bc = info.curve;
        if (bc == null) {
            return;
        }
        Vec3 previous1 = null;
        Vec3 previous2 = null;
        int railcolor = color;
        int segCount = bc.getSegmentCount();
        float s = animation.getValue() * 7.0f / 8.0f + 0.125f;
        float lw = animation.getValue() * 1.0f / 16.0f + 0.0625f;
        Vec3 end1 = (Vec3)bc.starts.getFirst();
        Vec3 end2 = (Vec3)bc.starts.getSecond();
        Vec3 finish1 = end1.m_82549_(((Vec3)bc.axes.getFirst()).m_82490_(bc.getHandleLength()));
        Vec3 finish2 = end2.m_82549_(((Vec3)bc.axes.getSecond()).m_82490_(bc.getHandleLength()));
        String key = "curve";
        for (i = 0; i <= segCount; ++i) {
            float t = (float)i / (float)segCount;
            Vec3 result = VecHelper.bezier(end1, end2, finish1, finish2, t);
            Vec3 derivative = VecHelper.bezierDerivative(end1, end2, finish1, finish2, t).m_82541_();
            Vec3 normal = bc.getNormal(t).m_82537_(derivative).m_82490_(0.9375);
            Vec3 rail1 = result.m_82549_(normal).m_82549_(up);
            Vec3 rail2 = result.m_82546_(normal).m_82549_(up);
            if (previous1 != null) {
                Vec3 middle1 = rail1.m_82549_(previous1).m_82490_(0.5);
                Vec3 middle2 = rail2.m_82549_(previous2).m_82490_(0.5);
                CreateClient.OUTLINER.showLine(Pair.of(key, i * 2), VecHelper.lerp(s, middle1, previous1), VecHelper.lerp(s, middle1, rail1)).colored(railcolor).disableNormals().lineWidth(lw);
                CreateClient.OUTLINER.showLine(Pair.of(key, i * 2 + 1), VecHelper.lerp(s, middle2, previous2), VecHelper.lerp(s, middle2, rail2)).colored(railcolor).disableNormals().lineWidth(lw);
            }
            previous1 = rail1;
            previous2 = rail2;
        }
        for (i = segCount + 1; i <= lastLineCount; ++i) {
            CreateClient.OUTLINER.remove(Pair.of(key, i * 2));
            CreateClient.OUTLINER.remove(Pair.of(key, i * 2 + 1));
        }
        lastLineCount = segCount;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void line(int id, Vec3 v1, Vec3 o1, Vec3 ex) {
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        CreateClient.OUTLINER.showLine(Pair.of("start", id), v1.m_82546_(o1), v1.m_82549_(ex)).lineWidth(0.125f).disableNormals().colored(color);
    }

    static {
        animation = LerpedFloat.linear().startWithValue(0.0);
        lastLineCount = 0;
    }

    public static class PlacementInfo {
        BezierConnection curve = null;
        boolean valid = false;
        int end1Extent = 0;
        int end2Extent = 0;
        String message = null;
        public int requiredTracks = 0;
        public boolean hasRequiredTracks = false;
        public int requiredPavement = 0;
        public boolean hasRequiredPavement = false;
        Vec3 end1;
        Vec3 end2;
        Vec3 normal1;
        Vec3 normal2;
        Vec3 axis1;
        Vec3 axis2;
        BlockPos pos1;
        BlockPos pos2;

        public PlacementInfo withMessage(String message) {
            this.message = "track." + message;
            return this;
        }

        public PlacementInfo tooJumbly() {
            this.curve = null;
            return this;
        }
    }
}

