/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.signal;

import com.google.common.base.Objects;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalPropagator;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalTileEntity;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SignalBoundary
extends TrackEdgePoint {
    public Couple<Map<BlockPos, Boolean>> blockEntities = Couple.create(HashMap::new);
    public Couple<SignalBlock.SignalType> types;
    public Couple<UUID> groups;
    public Couple<Boolean> sidesToUpdate;
    public Couple<SignalTileEntity.SignalState> cachedStates;
    private Couple<Map<UUID, Boolean>> chainedSignals = Couple.create(null, null);

    public SignalBoundary() {
        this.groups = Couple.create(null, null);
        this.sidesToUpdate = Couple.create(true, true);
        this.types = Couple.create(() -> SignalBlock.SignalType.ENTRY_SIGNAL);
        this.cachedStates = Couple.create(() -> SignalTileEntity.SignalState.INVALID);
    }

    public void setGroup(boolean primary, UUID groupId) {
        UUID previous = this.groups.get(primary);
        this.groups.set(primary, groupId);
        UUID opposite = this.groups.get(!primary);
        Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
        if (opposite != null && signalEdgeGroups.containsKey(opposite)) {
            SignalEdgeGroup oppositeGroup = signalEdgeGroups.get(opposite);
            if (previous != null) {
                oppositeGroup.removeAdjacent(previous);
            }
            if (groupId != null) {
                oppositeGroup.putAdjacent(groupId);
            }
        }
        if (groupId != null && signalEdgeGroups.containsKey(groupId)) {
            SignalEdgeGroup group = signalEdgeGroups.get(groupId);
            if (opposite != null) {
                group.putAdjacent(opposite);
            }
        }
    }

    public void setGroupAndUpdate(TrackNode side, UUID groupId) {
        boolean primary = this.isPrimary(side);
        this.setGroup(primary, groupId);
        this.sidesToUpdate.set(primary, false);
        this.chainedSignals.set(primary, null);
    }

    @Override
    public boolean canMerge() {
        return true;
    }

    @Override
    public void invalidate(LevelAccessor level) {
        this.blockEntities.forEach(s -> s.keySet().forEach(p -> this.invalidateAt(level, (BlockPos)p)));
        this.groups.forEach(uuid -> {
            if (Create.RAILWAYS.signalEdgeGroups.remove(uuid) != null) {
                Create.RAILWAYS.sync.edgeGroupRemoved((UUID)uuid);
            }
        });
    }

    @Override
    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == this.getType();
    }

    @Override
    public void tileAdded(BlockEntity tile, boolean front) {
        SignalTileEntity ste;
        Map<BlockPos, Boolean> tilesOnSide = this.blockEntities.get(front);
        if (tilesOnSide.isEmpty()) {
            tile.m_58900_().m_61145_(SignalBlock.TYPE).ifPresent(type -> this.types.set(front, (SignalBlock.SignalType)((Object)type)));
        }
        tilesOnSide.put(tile.m_58899_(), tile instanceof SignalTileEntity && (ste = (SignalTileEntity)tile).getReportedPower());
    }

    public void updateTilePower(SignalTileEntity tile) {
        for (boolean front : Iterate.trueAndFalse) {
            this.blockEntities.get(front).computeIfPresent(tile.m_58899_(), (p, c) -> tile.getReportedPower());
        }
    }

    @Override
    public void tileRemoved(BlockPos tilePos, boolean front) {
        this.blockEntities.forEach(s -> s.remove(tilePos));
        if (this.blockEntities.both(Map::isEmpty)) {
            this.removeFromAllGraphs();
        }
    }

    @Override
    public void onRemoved(TrackGraph graph) {
        super.onRemoved(graph);
        SignalPropagator.onSignalRemoved(graph, this);
    }

    public void queueUpdate(TrackNode side) {
        this.sidesToUpdate.set(this.isPrimary(side), true);
    }

    public UUID getGroup(TrackNode side) {
        return this.groups.get(this.isPrimary(side));
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return !this.blockEntities.get(this.isPrimary(side)).isEmpty();
    }

    public SignalTileEntity.OverlayState getOverlayFor(BlockPos tile) {
        for (boolean first : Iterate.trueAndFalse) {
            Map<BlockPos, Boolean> set = this.blockEntities.get(first);
            Iterator<BlockPos> iterator = set.keySet().iterator();
            if (!iterator.hasNext()) continue;
            BlockPos blockPos = iterator.next();
            if (blockPos.equals((Object)tile)) {
                return this.blockEntities.get(!first).isEmpty() ? SignalTileEntity.OverlayState.RENDER : SignalTileEntity.OverlayState.DUAL;
            }
            return SignalTileEntity.OverlayState.SKIP;
        }
        return SignalTileEntity.OverlayState.SKIP;
    }

    public SignalBlock.SignalType getTypeFor(BlockPos tile) {
        return this.types.get(((Map)this.blockEntities.getFirst()).containsKey(tile));
    }

    public SignalTileEntity.SignalState getStateFor(BlockPos tile) {
        for (boolean first : Iterate.trueAndFalse) {
            Map<BlockPos, Boolean> set = this.blockEntities.get(first);
            if (!set.containsKey(tile)) continue;
            return this.cachedStates.get(first);
        }
        return SignalTileEntity.SignalState.INVALID;
    }

    @Override
    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (!preTrains) {
            this.tickState(graph);
            return;
        }
        for (boolean front : Iterate.trueAndFalse) {
            if (!this.sidesToUpdate.get(front).booleanValue()) continue;
            this.sidesToUpdate.set(front, false);
            SignalPropagator.propagateSignalGroup(graph, this, front);
            this.chainedSignals.set(front, null);
        }
    }

    private void tickState(TrackGraph graph) {
        for (boolean current : Iterate.trueAndFalse) {
            Map<BlockPos, Boolean> set = this.blockEntities.get(current);
            if (set.isEmpty()) continue;
            boolean forcedRed = set.values().stream().anyMatch(Boolean::booleanValue);
            UUID group = this.groups.get(current);
            if (Objects.equal((Object)group, (Object)this.groups.get(!current))) {
                this.cachedStates.set(current, SignalTileEntity.SignalState.INVALID);
                continue;
            }
            Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
            SignalEdgeGroup signalEdgeGroup = signalEdgeGroups.get(group);
            if (signalEdgeGroup == null) {
                this.cachedStates.set(current, SignalTileEntity.SignalState.INVALID);
                continue;
            }
            boolean occupiedUnlessBySelf = forcedRed || signalEdgeGroup.isOccupiedUnless(this);
            this.cachedStates.set(current, occupiedUnlessBySelf ? SignalTileEntity.SignalState.RED : this.resolveSignalChain(graph, current));
        }
    }

    public boolean isForcedRed(TrackNode side) {
        return this.isForcedRed(this.isPrimary(side));
    }

    public boolean isForcedRed(boolean primary) {
        return this.blockEntities.get(primary).values().stream().anyMatch(Boolean::booleanValue);
    }

    private SignalTileEntity.SignalState resolveSignalChain(TrackGraph graph, boolean side) {
        if (this.types.get(side) != SignalBlock.SignalType.CROSS_SIGNAL) {
            return SignalTileEntity.SignalState.GREEN;
        }
        if (this.chainedSignals.get(side) == null) {
            this.chainedSignals.set(side, SignalPropagator.collectChainedSignals(graph, this, side));
        }
        boolean allPathsFree = true;
        boolean noPathsFree = true;
        boolean invalid = false;
        for (Map.Entry<UUID, Boolean> entry : this.chainedSignals.get(side).entrySet()) {
            UUID uuid = entry.getKey();
            boolean sideOfOther = entry.getValue();
            SignalBoundary otherSignal = graph.getPoint(EdgePointType.SIGNAL, uuid);
            if (otherSignal == null) {
                invalid = true;
                break;
            }
            if (otherSignal.blockEntities.get(sideOfOther).isEmpty()) continue;
            SignalTileEntity.SignalState otherState = otherSignal.cachedStates.get(sideOfOther);
            allPathsFree &= otherState == SignalTileEntity.SignalState.GREEN || otherState == SignalTileEntity.SignalState.INVALID;
            noPathsFree &= otherState == SignalTileEntity.SignalState.RED;
        }
        if (invalid) {
            this.chainedSignals.set(side, null);
            return SignalTileEntity.SignalState.INVALID;
        }
        if (allPathsFree) {
            return SignalTileEntity.SignalState.GREEN;
        }
        if (noPathsFree) {
            return SignalTileEntity.SignalState.RED;
        }
        return SignalTileEntity.SignalState.YELLOW;
    }

    @Override
    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        int i;
        super.read(nbt, migration, dimensions);
        if (migration) {
            return;
        }
        this.blockEntities = Couple.create(HashMap::new);
        this.groups = Couple.create(null, null);
        for (i = 1; i <= 2; ++i) {
            if (!nbt.m_128441_("Tiles" + i)) continue;
            boolean first = i == 1;
            NBTHelper.iterateCompoundList(nbt.m_128437_("Tiles" + i, 10), c -> this.blockEntities.get(first).put(NbtUtils.m_129239_((CompoundTag)c), c.m_128471_("Power")));
        }
        for (i = 1; i <= 2; ++i) {
            if (!nbt.m_128441_("Group" + i)) continue;
            this.groups.set(i == 1, nbt.m_128342_("Group" + i));
        }
        for (i = 1; i <= 2; ++i) {
            this.sidesToUpdate.set(i == 1, nbt.m_128441_("Update" + i));
        }
        for (i = 1; i <= 2; ++i) {
            this.types.set(i == 1, NBTHelper.readEnum(nbt, "Type" + i, SignalBlock.SignalType.class));
        }
        for (i = 1; i <= 2; ++i) {
            this.cachedStates.set(i == 1, NBTHelper.readEnum(nbt, "State" + i, SignalTileEntity.SignalState.class));
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        for (int i = 1; i <= 2; ++i) {
            if (!buffer.readBoolean()) continue;
            this.groups.set(i == 1, buffer.m_130259_());
        }
    }

    @Override
    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        int i;
        super.write(nbt, dimensions);
        for (i = 1; i <= 2; ++i) {
            if (this.blockEntities.get(i == 1).isEmpty()) continue;
            nbt.m_128365_("Tiles" + i, (Tag)NBTHelper.writeCompoundList(this.blockEntities.get(i == 1).entrySet(), e -> {
                CompoundTag c = NbtUtils.m_129224_((BlockPos)((BlockPos)e.getKey()));
                c.m_128379_("Power", ((Boolean)e.getValue()).booleanValue());
                return c;
            }));
        }
        for (i = 1; i <= 2; ++i) {
            if (this.groups.get(i == 1) == null) continue;
            nbt.m_128362_("Group" + i, this.groups.get(i == 1));
        }
        for (i = 1; i <= 2; ++i) {
            if (!this.sidesToUpdate.get(i == 1).booleanValue()) continue;
            nbt.m_128379_("Update" + i, true);
        }
        for (i = 1; i <= 2; ++i) {
            NBTHelper.writeEnum(nbt, "Type" + i, this.types.get(i == 1));
        }
        for (i = 1; i <= 2; ++i) {
            NBTHelper.writeEnum(nbt, "State" + i, this.cachedStates.get(i == 1));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        for (int i = 1; i <= 2; ++i) {
            boolean hasGroup = this.groups.get(i == 1) != null;
            buffer.writeBoolean(hasGroup);
            if (!hasGroup) continue;
            buffer.m_130077_(this.groups.get(i == 1));
        }
    }

    public void cycleSignalType(BlockPos pos) {
        this.types.set(((Map)this.blockEntities.getFirst()).containsKey(pos), SignalBlock.SignalType.values()[(this.getTypeFor(pos).ordinal() + 1) % SignalBlock.SignalType.values().length]);
    }
}

