/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TrainMigration {
    Couple<TrackNodeLocation> locations;
    double positionOnOldEdge;
    boolean curve;
    Vec3 fallback;

    public TrainMigration() {
    }

    public TrainMigration(TravellingPoint point) {
        double t = point.position / point.edge.getLength();
        this.fallback = point.edge.getPosition(t);
        this.curve = point.edge.isTurn();
        this.positionOnOldEdge = point.position;
        this.locations = Couple.create(point.node1.getLocation(), point.node2.getLocation());
    }

    public GraphLocation tryMigratingTo(TrackGraph graph) {
        TrackEdge edge;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getSecond()));
        if (node1 != null && node2 != null && (edge = graph.getConnectionsFrom(node1).get(node2)) != null) {
            GraphLocation graphLocation = new GraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = this.locations;
            graphLocation.position = this.positionOnOldEdge;
            return graphLocation;
        }
        if (this.curve) {
            return null;
        }
        Vec3 prevDirection = ((TrackNodeLocation)((Object)this.locations.getSecond())).getLocation().m_82546_(((TrackNodeLocation)((Object)this.locations.getFirst())).getLocation()).m_82541_();
        for (TrackNodeLocation loc : graph.getNodes()) {
            Vec3 nodeVec = loc.getLocation();
            if (nodeVec.m_82557_(this.fallback) > 1024.0) continue;
            TrackNode newNode1 = graph.locateNode(loc);
            for (Map.Entry<TrackNode, TrackEdge> entry : graph.getConnectionsFrom(newNode1).entrySet()) {
                Vec3 intersectSphere;
                TrackEdge edge2 = entry.getValue();
                if (edge2.isTurn()) continue;
                TrackNode newNode2 = entry.getKey();
                float radius = 0.015625f;
                Vec3 direction = edge2.getDirection(true);
                if (!Mth.m_14082_((double)direction.m_82526_(prevDirection), (double)1.0) || (intersectSphere = VecHelper.intersectSphere(nodeVec, direction, this.fallback, radius)) == null || !Mth.m_14082_((double)direction.m_82526_(intersectSphere.m_82546_(nodeVec).m_82541_()), (double)1.0)) continue;
                double edgeLength = edge2.getLength();
                double position = intersectSphere.m_82554_(nodeVec) - (double)radius;
                if (Double.isNaN(position) || position < 0.0 || position > edgeLength) continue;
                GraphLocation graphLocation = new GraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = Couple.create(loc, newNode2.getLocation());
                graphLocation.position = position;
                return graphLocation;
            }
        }
        return null;
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Curve", this.curve);
        tag.m_128365_("Fallback", (Tag)VecHelper.writeNBT(this.fallback));
        tag.m_128347_("Position", this.positionOnOldEdge);
        tag.m_128365_("Nodes", (Tag)this.locations.serializeEach(l -> l.write(dimensions)));
        return tag;
    }

    public static TrainMigration read(CompoundTag tag, DimensionPalette dimensions) {
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = tag.m_128471_("Curve");
        trainMigration.fallback = VecHelper.readNBT(tag.m_128437_("Fallback", 6));
        trainMigration.positionOnOldEdge = tag.m_128459_("Position");
        trainMigration.locations = Couple.deserializeEach(tag.m_128437_("Nodes", 10), c -> TrackNodeLocation.read(c, dimensions));
        return trainMigration;
    }
}

