/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrackNodeLocation
extends Vec3i {
    public ResourceKey<Level> dimension;

    public TrackNodeLocation(Vec3 vec) {
        this(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public TrackNodeLocation(double p_121865_, double p_121866_, double p_121867_) {
        super((double)Math.round(p_121865_ * 2.0), Math.floor(p_121866_ * 2.0), (double)Math.round(p_121867_ * 2.0));
    }

    public TrackNodeLocation in(Level level) {
        return this.in((ResourceKey<Level>)level.m_46472_());
    }

    public TrackNodeLocation in(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(BlockPos bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(BlockPos readBlockPos) {
        super(readBlockPos.m_123341_(), readBlockPos.m_123342_(), readBlockPos.m_123343_());
    }

    public Vec3 getLocation() {
        return new Vec3((double)((float)this.m_123341_() / 2.0f), (double)((float)this.m_123342_() / 2.0f), (double)((float)this.m_123343_() / 2.0f));
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    public boolean equalsIgnoreDim(Object pOther) {
        return super.equals(pOther);
    }

    public int hashCode() {
        return (this.m_123342_() + (this.m_123343_() * 31 + this.dimension.hashCode()) * 31) * 31 + this.m_123341_();
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag c = NbtUtils.m_129224_((BlockPos)new BlockPos((Vec3i)this));
        if (dimensions != null) {
            c.m_128405_("D", dimensions.encode(this.dimension));
        }
        return c;
    }

    public static TrackNodeLocation read(CompoundTag tag, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(NbtUtils.m_129239_((CompoundTag)tag));
        if (dimensions != null) {
            location.dimension = dimensions.decode(tag.m_128451_("D"));
        }
        return location;
    }

    public void send(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        buffer.m_130064_(new BlockPos((Vec3i)this));
        buffer.m_130130_(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(buffer.m_130135_());
        location.dimension = dimensions.decode(buffer.m_130242_());
        return location;
    }

    public Collection<BlockPos> allAdjacent() {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        Vec3 vec3 = this.getLocation();
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(new BlockPos(vec3.m_82520_((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        Vec3 direction;
        Vec3 normal;

        public DiscoveredLocation(Level level, double p_121865_, double p_121866_, double p_121867_) {
            super(p_121865_, p_121866_, p_121867_);
            this.in(level);
        }

        public DiscoveredLocation(ResourceKey<Level> dimension, Vec3 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(Level level, Vec3 vec) {
            this((ResourceKey<Level>)level.m_46472_(), vec);
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(Vec3 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withDirection(Vec3 direction) {
            this.direction = direction == null ? null : direction.m_82541_();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean notInLineWith(Vec3 direction) {
            return this.direction != null && Math.max(direction.m_82526_(this.direction), direction.m_82526_(this.direction.m_82490_(-1.0))) < 0.875;
        }
    }
}

