/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterContainer;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class FilterItem
extends Item
implements MenuProvider {
    private FilterType type;

    public static FilterItem regular(Item.Properties properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(Item.Properties properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    private FilterItem(FilterType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!AllKeys.shiftDown()) {
            List<Component> makeSummary = this.makeSummary(stack);
            if (makeSummary.isEmpty()) {
                return;
            }
            ItemDescription.add(tooltip, (Component)new TextComponent(" "));
            ItemDescription.add(tooltip, makeSummary);
        }
    }

    private List<Component> makeSummary(ItemStack filter) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
            list.add((Component)(blacklist ? Lang.translateDirect("gui.filter.deny_list", new Object[0]) : Lang.translateDirect("gui.filter.allow_list", new Object[0])).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                if (count > 3) {
                    list.add((Component)new TextComponent("- ...").m_130940_(ChatFormatting.DARK_GRAY));
                    break;
                }
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.m_41619_()) continue;
                list.add((Component)new TextComponent("- ").m_7220_(filterStack.m_41786_()).m_130940_(ChatFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
            list.add((Component)(whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ ? Lang.translateDirect("gui.attribute_filter.allow_list_conjunctive", new Object[0]) : (whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ ? Lang.translateDirect("gui.attribute_filter.allow_list_disjunctive", new Object[0]) : Lang.translateDirect("gui.attribute_filter.deny_list", new Object[0]))).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            ListTag attributes = filter.m_41784_().m_128437_("MatchedAttributes", 10);
            for (Tag inbt : attributes) {
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                boolean inverted = compound.m_128471_("Inverted");
                if (count > 3) {
                    list.add((Component)new TextComponent("- ...").m_130940_(ChatFormatting.DARK_GRAY));
                    break;
                }
                list.add((Component)new TextComponent("- ").m_7220_((Component)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!world.f_46443_ && player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.m_130055_(heldItem));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        ItemStack heldItem = player.m_21205_();
        if (this.type == FilterType.REGULAR) {
            return FilterContainer.create(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return AttributeFilterContainer.create(id, inv, heldItem);
        }
        return null;
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    public static ItemStackHandler getFilterItems(ItemStack stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER.get() != stack.m_41720_()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + stack);
        }
        CompoundTag invNBT = stack.m_41698_("Items");
        if (!invNBT.m_128456_()) {
            newInv.deserializeNBT(invNBT);
        }
        return newInv;
    }

    public static boolean test(Level world, ItemStack stack, ItemStack filter) {
        return FilterItem.test(world, stack, filter, false);
    }

    public static boolean test(Level world, FluidStack stack, ItemStack filter) {
        return FilterItem.test(world, stack, filter, true);
    }

    private static boolean test(Level world, ItemStack stack, ItemStack filter, boolean matchNBT) {
        if (filter.m_41619_()) {
            return true;
        }
        if (!(filter.m_41720_() instanceof FilterItem)) {
            return matchNBT ? ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack) : ItemStack.m_41746_((ItemStack)filter, (ItemStack)stack);
        }
        if (AllItems.FILTER.get() == filter.m_41720_()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = filter.m_41784_().m_128471_("RespectNBT");
            boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
            for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                boolean matches;
                ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.m_41619_() || !(matches = FilterItem.test(world, stack, stackInSlot, respectNBT))) continue;
                return !blacklist;
            }
            return blacklist;
        }
        if (AllItems.ATTRIBUTE_FILTER.get() == filter.m_41720_()) {
            AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
            ListTag attributes = filter.m_41784_().m_128437_("MatchedAttributes", 10);
            block16: for (Tag inbt : attributes) {
                boolean matches;
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                boolean bl = matches = attribute.appliesTo(stack, world) != compound.m_128471_("Inverted");
                if (matches) {
                    switch (whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block16;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (whitelistMode) {
                    case BLACKLIST: {
                        continue block16;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                    case WHITELIST_DISJ: {
                        continue block16;
                    }
                }
            }
            switch (whitelistMode) {
                case BLACKLIST: {
                    return true;
                }
                case WHITELIST_CONJ: {
                    return true;
                }
                case WHITELIST_DISJ: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean test(Level world, FluidStack stack, ItemStack filter, boolean matchNBT) {
        if (filter.m_41619_()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        if (!(filter.m_41720_() instanceof FilterItem)) {
            if (!EmptyingByBasin.canItemBeEmptied(world, filter)) {
                return false;
            }
            FluidStack fluidInFilter = EmptyingByBasin.emptyItem(world, filter, true).getFirst();
            if (fluidInFilter == null) {
                return false;
            }
            if (!matchNBT) {
                return fluidInFilter.getFluid().m_6212_(stack.getFluid());
            }
            boolean fluidEqual = fluidInFilter.isFluidEqual(stack);
            return fluidEqual;
        }
        if (AllItems.FILTER.get() == filter.m_41720_()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = filter.m_41784_().m_128471_("RespectNBT");
            boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
            for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                boolean matches;
                ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.m_41619_() || !(matches = FilterItem.test(world, stack, stackInSlot, respectNBT))) continue;
                return !blacklist;
            }
            return blacklist;
        }
        return false;
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE;

    }
}

