/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;

public class ArmInstance
extends SingleRotatingInstance
implements DynamicInstance {
    final ModelData base;
    final ModelData lowerBody;
    final ModelData upperBody;
    final ModelData head;
    final ModelData claw;
    private final ArrayList<ModelData> clawGrips;
    private final ArrayList<ModelData> models;
    private final ArmTileEntity arm;
    private final Boolean ceiling;
    private boolean firstRender = true;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmInstance(MaterialManager modelManager, ArmTileEntity tile) {
        super(modelManager, tile);
        Material mat = this.getTransformMaterial();
        this.base = (ModelData)mat.getModel(AllBlockPartials.ARM_BASE, this.blockState).createInstance();
        this.lowerBody = (ModelData)mat.getModel(AllBlockPartials.ARM_LOWER_BODY, this.blockState).createInstance();
        this.upperBody = (ModelData)mat.getModel(AllBlockPartials.ARM_UPPER_BODY, this.blockState).createInstance();
        this.head = (ModelData)mat.getModel(AllBlockPartials.ARM_HEAD, this.blockState).createInstance();
        this.claw = (ModelData)mat.getModel(AllBlockPartials.ARM_CLAW_BASE, this.blockState).createInstance();
        Instancer clawHalfModel = mat.getModel(AllBlockPartials.ARM_CLAW_GRIP, this.blockState);
        ModelData clawGrip1 = (ModelData)clawHalfModel.createInstance();
        ModelData clawGrip2 = (ModelData)clawHalfModel.createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new ModelData[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new ModelData[]{this.base, this.lowerBody, this.upperBody, this.head, this.claw, clawGrip1, clawGrip2});
        this.arm = tile;
        this.ceiling = (Boolean)this.blockState.m_61143_((Property)ArmBlock.CEILING);
        this.animateArm(false);
    }

    public void beginFrame() {
        if (this.arm.phase == ArmTileEntity.Phase.DANCING && ((KineticTileEntity)this.blockEntity).getSpeed() != 0.0f) {
            this.animateArm(true);
            this.firstRender = true;
            return;
        }
        float pt = AnimationTickHolder.getPartialTicks();
        float baseAngleNow = this.arm.baseAngle.getValue(pt);
        float lowerArmAngleNow = this.arm.lowerArmAngle.getValue(pt);
        float upperArmAngleNow = this.arm.upperArmAngle.getValue(pt);
        float headAngleNow = this.arm.headAngle.getValue(pt);
        boolean settled = Mth.m_14033_((float)this.baseAngle, (float)baseAngleNow) && Mth.m_14033_((float)this.lowerArmAngle, (float)lowerArmAngleNow) && Mth.m_14033_((float)this.upperArmAngle, (float)upperArmAngleNow) && Mth.m_14033_((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.firstRender) {
            this.animateArm(false);
        }
        if (this.firstRender) {
            this.firstRender = false;
        }
    }

    private void animateArm(boolean rave) {
        int color;
        float headAngle;
        float upperArmAngle;
        float lowerArmAngle;
        float baseAngle;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)this.arm.m_58904_()) + (float)(((KineticTileEntity)this.blockEntity).hashCode() % 64);
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = Mth.m_14179_((float)((Mth.m_14031_((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = this.baseAngle;
            lowerArmAngle = this.lowerArmAngle - 135.0f;
            upperArmAngle = this.upperArmAngle - 90.0f;
            headAngle = this.headAngle;
            color = 0xFFFFFF;
        }
        PoseStack msLocal = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)msLocal);
        msr.translate((Vec3i)this.getInstancePosition());
        msr.centre();
        if (this.ceiling.booleanValue()) {
            msr.rotateX(180.0);
        }
        ArmRenderer.transformBase(msr, baseAngle);
        this.base.setTransform(msLocal);
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        this.lowerBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        this.upperBody.setTransform(msLocal).setColor(color);
        ArmRenderer.transformHead(msr, headAngle);
        this.head.setTransform(msLocal);
        ArmRenderer.transformClaw(msr);
        this.claw.setTransform(msLocal);
        ItemStack item = this.arm.heldItem;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        boolean hasItem = !item.m_41619_();
        boolean isBlockItem = hasItem && item.m_41720_() instanceof BlockItem && itemRenderer.m_174264_(item, (Level)Minecraft.m_91087_().f_91073_, null, 0).m_7539_();
        for (int index : Iterate.zeroAndOne) {
            msLocal.m_85836_();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform(msLocal);
            msLocal.m_85849_();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.models.stream());
    }

    @Override
    protected Instancer<RotatingData> getModel() {
        return this.getRotatingMaterial().getModel(AllBlockPartials.ARM_COG, ((KineticTileEntity)this.blockEntity).m_58900_());
    }

    @Override
    public void remove() {
        super.remove();
        this.models.forEach(InstanceData::delete);
    }
}

