/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FunnelRenderer
extends SmartTileEntityRenderer<FunnelTileEntity> {
    public FunnelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(FunnelTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (!te.hasFlap() || Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState blockState = te.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        PartialModel partialModel = blockState.m_60734_() instanceof FunnelBlock ? AllBlockPartials.FUNNEL_FLAP : AllBlockPartials.BELT_FUNNEL_FLAP;
        SuperByteBuffer flapBuffer = CachedBufferer.partial(partialModel, blockState);
        Vec3 pivot = VecHelper.voxelSpace(0.0, 10.0, 9.5);
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        float horizontalAngle = AngleHelper.horizontalAngle(FunnelBlock.getFunnelFacing(blockState).m_122424_());
        float f = te.flap.getValue(partialTicks);
        ms.m_85836_();
        ((TransformStack)((TransformStack)msr.centre()).rotateY((double)horizontalAngle)).unCentre();
        ms.m_85837_(0.0, 0.0, (double)(-te.getFlapOffset()));
        for (int segment = 0; segment <= 3; ++segment) {
            ms.m_85836_();
            float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
            float abs = Math.abs(f);
            float flapAngle = Mth.m_14031_((float)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * -f;
            if (f > 0.0f) {
                flapAngle *= 0.5f;
            }
            ((TransformStack)((TransformStack)msr.translate(pivot)).rotateX((double)flapAngle)).translateBack(pivot);
            flapBuffer.light(light).renderInto(ms, vb);
            ms.m_85849_();
            ms.m_85837_(-0.1875, 0.0, 0.0);
        }
        ms.m_85849_();
    }
}

