/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.source.DeathCounterDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.source.EnchantPowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.RedstonePowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.ScoreboardDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.LecternDisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.SignDisplayTarget;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IRegistryDelegate;

public class AllDisplayBehaviours {
    public static final Map<ResourceLocation, DisplayBehaviour> GATHERER_BEHAVIOURS = new HashMap<ResourceLocation, DisplayBehaviour>();
    public static final Map<IRegistryDelegate<Block>, List<DisplaySource>> SOURCES_BY_BLOCK = new HashMap<IRegistryDelegate<Block>, List<DisplaySource>>();
    public static final Map<IRegistryDelegate<BlockEntityType<?>>, List<DisplaySource>> SOURCES_BY_TILE = new HashMap();
    public static final Map<IRegistryDelegate<Block>, DisplayTarget> TARGETS_BY_BLOCK = new HashMap<IRegistryDelegate<Block>, DisplayTarget>();
    public static final Map<IRegistryDelegate<BlockEntityType<?>>, DisplayTarget> TARGETS_BY_TILE = new HashMap();

    public static DisplayBehaviour register(ResourceLocation id, DisplayBehaviour behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(DisplayBehaviour behaviour, IRegistryDelegate<Block> block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            SOURCES_BY_BLOCK.computeIfAbsent(block, r -> new ArrayList()).add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.put(block, target);
        }
    }

    public static void assignTile(DisplayBehaviour behaviour, IRegistryDelegate<BlockEntityType<?>> teType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            SOURCES_BY_TILE.computeIfAbsent(teType, r -> new ArrayList()).add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_TILE.put(teType, target);
        }
    }

    public static <B extends Block> NonNullConsumer<? super B> assignDataBehaviour(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = b.getRegistryName();
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), (IRegistryDelegate<Block>)b.delegate);
        };
    }

    public static <B extends BlockEntityType<?>> NonNullConsumer<? super B> assignDataBehaviourTE(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = b.getRegistryName();
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), b.delegate);
        };
    }

    @Nullable
    public static DisplaySource getSource(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static DisplayTarget getTarget(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)available;
            return target;
        }
        return null;
    }

    public static List<DisplaySource> sourcesOf(Block block) {
        return SOURCES_BY_BLOCK.getOrDefault(block.delegate, Collections.emptyList());
    }

    public static List<DisplaySource> sourcesOf(BlockState state) {
        return AllDisplayBehaviours.sourcesOf(state.m_60734_());
    }

    public static List<DisplaySource> sourcesOf(BlockEntityType<?> tileEntityType) {
        return SOURCES_BY_TILE.getOrDefault(tileEntityType.delegate, Collections.emptyList());
    }

    public static List<DisplaySource> sourcesOf(BlockEntity tileEntity) {
        return AllDisplayBehaviours.sourcesOf(tileEntity.m_58903_());
    }

    @Nullable
    public static DisplayTarget targetOf(Block block) {
        return TARGETS_BY_BLOCK.get(block.delegate);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockState state) {
        return AllDisplayBehaviours.targetOf(state.m_60734_());
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntityType<?> tileEntityType) {
        return TARGETS_BY_TILE.get(tileEntityType.delegate);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntity tileEntity) {
        return AllDisplayBehaviours.targetOf(tileEntity.m_58903_());
    }

    public static List<DisplaySource> sourcesOf(LevelAccessor level, BlockPos pos) {
        List<Object> sourcesOfTE;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        List<DisplaySource> sourcesOfBlock = AllDisplayBehaviours.sourcesOf(blockState);
        List<Object> list = sourcesOfTE = blockEntity == null ? Collections.emptyList() : AllDisplayBehaviours.sourcesOf(blockEntity);
        if (sourcesOfTE.isEmpty()) {
            return sourcesOfBlock;
        }
        return sourcesOfTE;
    }

    @Nullable
    public static DisplayTarget targetOf(LevelAccessor level, BlockPos pos) {
        DisplayTarget targetOfTE;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        DisplayTarget targetOfBlock = AllDisplayBehaviours.targetOf(blockState);
        DisplayTarget displayTarget = targetOfTE = blockEntity == null ? null : AllDisplayBehaviours.targetOf(blockEntity);
        if (targetOfTE == null) {
            return targetOfBlock;
        }
        return targetOfTE;
    }

    public static void registerDefaults() {
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("sign_display_target"), new SignDisplayTarget()), BlockEntityType.f_58924_.delegate);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("lectern_display_target"), new LecternDisplayTarget()), BlockEntityType.f_58908_.delegate);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("death_count_display_source"), new DeathCounterDisplaySource()), (IRegistryDelegate<Block>)Blocks.f_50724_.delegate);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("scoreboard_display_source"), new ScoreboardDisplaySource()), BlockEntityType.f_58938_.delegate);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("enchant_power_display_source"), new EnchantPowerDisplaySource()), BlockEntityType.f_58928_.delegate);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("redstone_power_display_source"), new RedstonePowerDisplaySource()), (IRegistryDelegate<Block>)Blocks.f_50716_.delegate);
    }
}

