/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.tools.BlueprintContainer;
import com.simibubi.create.content.curiosities.tools.BlueprintItem;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;

public class BlueprintEntity
extends HangingEntity
implements IEntityAdditionalSpawnData,
ISpecialEntityItemRequirement,
ISyncPersistentData,
IInteractionChecker {
    protected int size;
    protected Direction verticalOrientation;
    private Map<Integer, BlueprintSection> sectionCache = new HashMap<Integer, BlueprintSection>();

    public BlueprintEntity(EntityType<?> p_i50221_1_, Level p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        this.size = 1;
    }

    public BlueprintEntity(Level world, BlockPos pos, Direction facing, Direction verticalOrientation) {
        super((EntityType)AllEntityTypes.CRAFTING_BLUEPRINT.get(), world, pos);
        int size = 3;
        while (size > 0) {
            this.size = size--;
            this.updateFacingWithBoundingBox(facing, verticalOrientation);
            if (this.m_7088_()) break;
        }
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        p_213281_1_.m_128344_("Orientation", (byte)this.verticalOrientation.m_122411_());
        p_213281_1_.m_128405_("Size", this.size);
        super.m_7380_(p_213281_1_);
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        if (p_70037_1_.m_128425_("Facing", 99)) {
            this.f_31699_ = Direction.m_122376_((int)p_70037_1_.m_128445_("Facing"));
            this.verticalOrientation = Direction.m_122376_((int)p_70037_1_.m_128445_("Orientation"));
            this.size = p_70037_1_.m_128451_("Size");
        } else {
            this.f_31699_ = Direction.SOUTH;
            this.verticalOrientation = Direction.DOWN;
            this.size = 1;
        }
        super.m_7378_(p_70037_1_);
        this.updateFacingWithBoundingBox(this.f_31699_, this.verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(Direction facing, Direction verticalOrientation) {
        Validate.notNull((Object)facing);
        this.f_31699_ = facing;
        this.verticalOrientation = verticalOrientation;
        if (facing.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facing.m_122421_().m_122540_());
            this.m_146922_(verticalOrientation.m_122434_().m_122479_() ? 180.0f + verticalOrientation.m_122435_() : 0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    protected float m_6380_(Pose p_213316_1_, EntityDimensions p_213316_2_) {
        return 0.0f;
    }

    protected void m_7087_() {
        if (this.f_31699_ == null) {
            return;
        }
        if (this.verticalOrientation == null) {
            return;
        }
        Vec3 pos = Vec3.m_82528_((Vec3i)this.m_31748_()).m_82520_(0.5, 0.5, 0.5).m_82546_(Vec3.m_82528_((Vec3i)this.f_31699_.m_122436_()).m_82490_(0.46875));
        double d1 = pos.f_82479_;
        double d2 = pos.f_82480_;
        double d3 = pos.f_82481_;
        this.m_20343_(d1, d2, d3);
        Direction.Axis axis = this.f_31699_.m_122434_();
        if (this.size == 2) {
            pos = pos.m_82549_(Vec3.m_82528_((Vec3i)(axis.m_122479_() ? this.f_31699_.m_122428_().m_122436_() : this.verticalOrientation.m_122427_().m_122436_())).m_82490_(0.5)).m_82549_(Vec3.m_82528_((Vec3i)(axis.m_122479_() ? Direction.UP.m_122436_() : (this.f_31699_ == Direction.UP ? this.verticalOrientation.m_122436_() : this.verticalOrientation.m_122424_().m_122436_()))).m_82490_(0.5));
        }
        d1 = pos.f_82479_;
        d2 = pos.f_82480_;
        d3 = pos.f_82481_;
        double d4 = this.m_7076_();
        double d5 = this.m_7068_();
        double d6 = this.m_7076_();
        Direction.Axis direction$axis = this.f_31699_.m_122434_();
        switch (direction$axis) {
            case X: {
                d4 = 1.0;
                break;
            }
            case Y: {
                d5 = 1.0;
                break;
            }
            case Z: {
                d6 = 1.0;
            }
        }
        this.m_20011_(new AABB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
    }

    public boolean m_7088_() {
        if (!this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        int i = Math.max(1, this.m_7076_() / 16);
        int j = Math.max(1, this.m_7068_() / 16);
        BlockPos blockpos = this.f_31698_.m_142300_(this.f_31699_.m_122424_());
        Direction upDirection = this.f_31699_.m_122434_().m_122479_() ? Direction.UP : (this.f_31699_ == Direction.UP ? this.verticalOrientation : this.verticalOrientation.m_122424_());
        Direction newDirection = this.f_31699_.m_122434_().m_122478_() ? this.verticalOrientation.m_122427_() : this.f_31699_.m_122428_();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.m_122190_((Vec3i)blockpos).m_122175_(newDirection, k + i1).m_122175_(upDirection, l + j1);
                BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                if (Block.m_49863_((LevelReader)this.f_19853_, (BlockPos)blockpos$mutable, (Direction)this.f_31699_) || blockstate.m_60767_().m_76333_() || DiodeBlock.m_52586_((BlockState)blockstate)) continue;
                return false;
            }
        }
        return this.f_19853_.m_6249_((Entity)this, this.m_142469_(), f_31697_).isEmpty();
    }

    public int m_7076_() {
        return 16 * this.size;
    }

    public int m_7068_() {
        return 16 * this.size;
    }

    public boolean m_7313_(Entity source) {
        if (!(source instanceof Player) || this.f_19853_.f_46443_) {
            return super.m_7313_(source);
        }
        Player player = (Player)source;
        double attrib = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + (double)(player.m_7500_() ? 0.0f : -0.5f);
        Vec3 eyePos = source.m_20299_(1.0f);
        Vec3 look = source.m_20252_(1.0f);
        Vec3 target = eyePos.m_82549_(look.m_82490_(attrib));
        Optional rayTrace = this.m_142469_().m_82371_(eyePos, target);
        if (!rayTrace.isPresent()) {
            return super.m_7313_(source);
        }
        Vec3 hitVec = (Vec3)rayTrace.get();
        BlueprintSection sectionAt = this.getSectionAt(hitVec.m_82546_(this.m_20182_()));
        ItemStackHandler items = sectionAt.getItems();
        if (items.getStackInSlot(9).m_41619_()) {
            return super.m_7313_(source);
        }
        for (int i = 0; i < items.getSlots(); ++i) {
            items.setStackInSlot(i, ItemStack.f_41583_);
        }
        sectionAt.save(items);
        return true;
    }

    public void m_5553_(@Nullable Entity p_110128_1_) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
        if (p_110128_1_ instanceof Player) {
            Player playerentity = (Player)p_110128_1_;
            if (playerentity.m_150110_().f_35937_) {
                return;
            }
        }
        this.m_19983_(AllItems.CRAFTING_BLUEPRINT.asStack());
    }

    public ItemStack getPickedResult(HitResult target) {
        return AllItems.CRAFTING_BLUEPRINT.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, (Item)AllItems.CRAFTING_BLUEPRINT.get());
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.m_6034_(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        BlockPos blockpos = this.f_31698_.m_142022_(p_180426_1_ - this.m_20185_(), p_180426_3_ - this.m_20186_(), p_180426_5_ - this.m_20189_());
        this.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
        buffer.m_130079_(this.getPersistentData());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
        this.getPersistentData().m_128391_(additionalData.m_130260_());
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        boolean holdingWrench = AllItems.WRENCH.isIn(player.m_21120_(hand));
        BlueprintSection section = this.getSectionAt(vec);
        ItemStackHandler items = section.getItems();
        if (!(holdingWrench || this.f_19853_.f_46443_ || items.getStackInSlot(9).m_41619_())) {
            InvWrapper playerInv = new InvWrapper((Container)player.m_150109_());
            boolean firstPass = true;
            int amountCrafted = 0;
            ForgeHooks.setCraftingPlayer((Player)player);
            Optional recipe = Optional.empty();
            do {
                HashMap<Integer, ItemStack> stacksTaken = new HashMap<Integer, ItemStack>();
                HashMap<Integer, ItemStack> craftingGrid = new HashMap<Integer, ItemStack>();
                boolean success = true;
                block1: for (int i = 0; i < 9; ++i) {
                    ItemStack requestedItem = items.getStackInSlot(i);
                    if (requestedItem.m_41619_()) {
                        craftingGrid.put(i, ItemStack.f_41583_);
                        continue;
                    }
                    for (int slot = 0; slot < playerInv.getSlots(); ++slot) {
                        if (!FilterItem.test(this.f_19853_, playerInv.getStackInSlot(slot), requestedItem)) continue;
                        ItemStack currentItem = playerInv.extractItem(slot, 1, false);
                        if (stacksTaken.containsKey(slot)) {
                            ((ItemStack)stacksTaken.get(slot)).m_41769_(1);
                        } else {
                            stacksTaken.put(slot, currentItem.m_41777_());
                        }
                        craftingGrid.put(i, currentItem);
                        continue block1;
                    }
                    success = false;
                    break;
                }
                if (success) {
                    ItemStack result;
                    BlueprintCraftingInventory craftingInventory = new BlueprintCraftingInventory(craftingGrid);
                    if (!recipe.isPresent()) {
                        recipe = this.f_19853_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, this.f_19853_);
                    }
                    if ((result = recipe.filter(r -> r.m_5818_((Container)craftingInventory, this.f_19853_)).map(r -> r.m_5874_((Container)craftingInventory)).orElse(ItemStack.f_41583_)).m_41619_()) {
                        success = false;
                    } else if (result.m_41613_() + amountCrafted > 64) {
                        success = false;
                    } else {
                        amountCrafted += result.m_41613_();
                        result.m_41678_(player.f_19853_, player, 1);
                        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)result, (Container)craftingInventory);
                        NonNullList nonnulllist = this.f_19853_.m_7465_().m_44069_(RecipeType.f_44107_, (Container)craftingInventory, this.f_19853_);
                        if (firstPass) {
                            this.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
                        }
                        player.m_150109_().m_150079_(result);
                        for (ItemStack itemStack : nonnulllist) {
                            player.m_150109_().m_150079_(itemStack);
                        }
                        firstPass = false;
                    }
                }
                if (success) continue;
                for (Map.Entry entry : stacksTaken.entrySet()) {
                    playerInv.insertItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue(), false);
                }
                break;
            } while (player.m_6144_());
            ForgeHooks.setCraftingPlayer(null);
            return InteractionResult.SUCCESS;
        }
        int i = section.index;
        if (!this.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)section, buf -> {
                buf.m_130130_(this.m_142049_());
                buf.m_130130_(i);
            });
        }
        return InteractionResult.SUCCESS;
    }

    public BlueprintSection getSectionAt(Vec3 vec) {
        int index = 0;
        if (this.size > 1) {
            vec = VecHelper.rotate(vec, this.m_146908_(), Direction.Axis.Y);
            vec = VecHelper.rotate(vec, -this.m_146909_(), Direction.Axis.X);
            vec = vec.m_82520_(0.5, 0.5, 0.0);
            if (this.size == 3) {
                vec = vec.m_82520_(1.0, 1.0, 0.0);
            }
            int x = Mth.m_14045_((int)Mth.m_14107_((double)vec.f_82479_), (int)0, (int)(this.size - 1));
            int y = Mth.m_14045_((int)Mth.m_14107_((double)vec.f_82480_), (int)0, (int)(this.size - 1));
            index = x + y * this.size;
        }
        BlueprintSection section = this.getSection(index);
        return section;
    }

    public CompoundTag getOrCreateRecipeCompound() {
        CompoundTag persistentData = this.getPersistentData();
        if (!persistentData.m_128441_("Recipes")) {
            persistentData.m_128365_("Recipes", (Tag)new CompoundTag());
        }
        return persistentData.m_128469_("Recipes");
    }

    public BlueprintSection getSection(int index) {
        return this.sectionCache.computeIfAbsent(index, i -> new BlueprintSection((int)i));
    }

    @Override
    public void onPersistentDataUpdated() {
        this.sectionCache.clear();
    }

    @Override
    public boolean canPlayerUse(Player player) {
        AABB box = this.m_142469_();
        double dx = 0.0;
        if (box.f_82288_ > player.m_20185_()) {
            dx = box.f_82288_ - player.m_20185_();
        } else if (player.m_20185_() > box.f_82291_) {
            dx = player.m_20185_() - box.f_82291_;
        }
        double dy = 0.0;
        if (box.f_82289_ > player.m_20186_()) {
            dy = box.f_82289_ - player.m_20186_();
        } else if (player.m_20186_() > box.f_82292_) {
            dy = player.m_20186_() - box.f_82292_;
        }
        double dz = 0.0;
        if (box.f_82290_ > player.m_20189_()) {
            dz = box.f_82290_ - player.m_20189_();
        } else if (player.m_20189_() > box.f_82293_) {
            dz = player.m_20189_() - box.f_82293_;
        }
        return dx * dx + dy * dy + dz * dz <= 64.0;
    }

    class BlueprintSection
    implements MenuProvider,
    IInteractionChecker {
        int index;
        Couple<ItemStack> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<ItemStack> getDisplayItems() {
            if (this.cachedDisplayItems != null) {
                return this.cachedDisplayItems;
            }
            ItemStackHandler items = this.getItems();
            this.cachedDisplayItems = Couple.create(items.getStackInSlot(9), items.getStackInSlot(10));
            return this.cachedDisplayItems;
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            CompoundTag list = BlueprintEntity.this.getOrCreateRecipeCompound();
            CompoundTag invNBT = list.m_128469_("" + this.index);
            this.inferredIcon = list.m_128471_("InferredIcon");
            if (!invNBT.m_128456_()) {
                newInv.deserializeNBT(invNBT);
            }
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            CompoundTag list = BlueprintEntity.this.getOrCreateRecipeCompound();
            list.m_128365_("" + this.index, (Tag)inventory.serializeNBT());
            list.m_128379_("InferredIcon", this.inferredIcon);
            this.cachedDisplayItems = null;
            if (!BlueprintEntity.this.f_19853_.f_46443_) {
                BlueprintEntity.this.syncPersistentDataWithTracking((Entity)BlueprintEntity.this);
            }
        }

        public boolean isEntityAlive() {
            return BlueprintEntity.this.m_6084_();
        }

        public Level getBlueprintWorld() {
            return BlueprintEntity.this.f_19853_;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
            return BlueprintContainer.create(id, inv, this);
        }

        public Component m_5446_() {
            return ((BlueprintItem)((Object)AllItems.CRAFTING_BLUEPRINT.get())).m_41466_();
        }

        @Override
        public boolean canPlayerUse(Player player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }
    }

    static class BlueprintCraftingInventory
    extends CraftingContainer {
        private static final AbstractContainerMenu dummyContainer = new AbstractContainerMenu(null, -1){

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        };

        public BlueprintCraftingInventory(Map<Integer, ItemStack> items) {
            super(dummyContainer, 3, 3);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    ItemStack stack = items.get(y * 3 + x);
                    this.m_6836_(y * 3 + x, stack == null ? ItemStack.f_41583_ : stack.m_41777_());
                }
            }
        }
    }
}

