/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxSlot;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.container.ContainerBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ToolboxContainer
extends ContainerBase<ToolboxTileEntity> {
    public boolean renderPass;

    public ToolboxContainer(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public ToolboxContainer(MenuType<?> type, int id, Inventory inv, ToolboxTileEntity te) {
        super(type, id, inv, te);
        te.startOpen(this.player);
    }

    public static ToolboxContainer create(int id, Inventory inv, ToolboxTileEntity te) {
        return new ToolboxContainer((MenuType)AllContainerTypes.TOOLBOX.get(), id, inv, te);
    }

    @Override
    protected ToolboxTileEntity createOnClient(FriendlyByteBuf extraData) {
        BlockPos readBlockPos = extraData.m_130135_();
        CompoundTag readNbt = extraData.m_130260_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity tileEntity = world.m_7702_(readBlockPos);
        if (tileEntity instanceof ToolboxTileEntity) {
            ToolboxTileEntity toolbox = (ToolboxTileEntity)tileEntity;
            toolbox.readClient(readNbt);
            return toolbox;
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot clickedSlot = this.m_38853_(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = clickedSlot.m_7993_();
        int size = ((ToolboxTileEntity)this.contentHolder).inventory.getSlots();
        boolean success = false;
        if (index < size) {
            success = !this.m_38903_(stack, size, this.f_38839_.size(), false);
            ((ToolboxTileEntity)this.contentHolder).inventory.onContentsChanged(index);
        } else {
            success = !this.m_38903_(stack, 0, size - 1, false);
        }
        return success ? ItemStack.f_41583_ : stack;
    }

    @Override
    protected void initAndReadInventory(ToolboxTileEntity contentHolder) {
    }

    public void m_150399_(int index, int flags, ClickType type, Player player) {
        int size = ((ToolboxTileEntity)this.contentHolder).inventory.getSlots();
        if (index >= 0 && index < size) {
            int subIndex;
            ItemStack itemInClickedSlot = this.m_38853_(index).m_7993_();
            ItemStack carried = this.m_142621_();
            if (type == ClickType.PICKUP && !carried.m_41619_() && !itemInClickedSlot.m_41619_() && ToolboxInventory.canItemsShareCompartment(itemInClickedSlot, carried) && (subIndex = index % 4) != 3) {
                this.m_150399_(index - subIndex + 4 - 1, flags, type, player);
                return;
            }
            if (type == ClickType.PICKUP && carried.m_41619_() && itemInClickedSlot.m_41619_() && !player.f_19853_.f_46443_) {
                ((ToolboxTileEntity)this.contentHolder).inventory.filters.set(index / 4, ItemStack.f_41583_);
                ((ToolboxTileEntity)this.contentHolder).sendData();
            }
        }
        super.m_150399_(index, flags, type, player);
    }

    public boolean m_5622_(Slot slot) {
        return slot.f_40219_ > ((ToolboxTileEntity)this.contentHolder).inventory.getSlots() && super.m_5622_(slot);
    }

    public ItemStack getFilter(int compartment) {
        return ((ToolboxTileEntity)this.contentHolder).inventory.filters.get(compartment);
    }

    public int totalCountInCompartment(int compartment) {
        int count = 0;
        int baseSlot = compartment * 4;
        for (int i = 0; i < 4; ++i) {
            count += this.m_38853_(baseSlot + i).m_7993_().m_41613_();
        }
        return count;
    }

    @Override
    protected void addSlots() {
        ToolboxInventory inventory = ((ToolboxTileEntity)this.contentHolder).inventory;
        int x = 79;
        int y = 37;
        int[] xOffsets = new int[]{x, x + 33, x + 66, x + 66 + 6, x + 66, x + 33, x, x - 6};
        int[] yOffsets = new int[]{y, y - 6, y, y + 33, y + 66, y + 66 + 6, y + 66, y + 33};
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            this.m_38897_((Slot)new ToolboxSlot(this, (IItemHandler)inventory, baseIndex, xOffsets[compartment], yOffsets[compartment]));
            for (int i = 1; i < 4; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, baseIndex + i, -10000, -10000));
            }
        }
        this.addPlayerSlots(8, 165);
    }

    @Override
    protected void saveData(ToolboxTileEntity contentHolder) {
    }

    @Override
    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.f_19853_.f_46443_) {
            ((ToolboxTileEntity)this.contentHolder).stopOpen(playerIn);
        }
    }
}

