/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.item;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractSimpleShaftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BeltConnectorItem
extends BlockItem {
    public BeltConnectorItem(Item.Properties properties) {
        super((Block)AllBlocks.BELT.get(), properties);
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public void m_6787_(CreativeModeTab p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (p_150895_1_ == Create.BASE_CREATIVE_TAB) {
            return;
        }
        super.m_6787_(p_150895_1_, p_150895_2_);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player playerEntity = context.m_43723_();
        if (playerEntity != null && playerEntity.m_6144_()) {
            context.m_43722_().m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean validAxis = BeltConnectorItem.validateAxis(world, pos);
        if (world.f_46443_) {
            return validAxis ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        CompoundTag tag = context.m_43722_().m_41784_();
        BlockPos firstPulley = null;
        if (!(!tag.m_128441_("FirstPulley") || BeltConnectorItem.validateAxis(world, firstPulley = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstPulley"))) && firstPulley.m_123314_((Vec3i)pos, (double)(BeltConnectorItem.maxLength() * 2)))) {
            tag.m_128473_("FirstPulley");
            context.m_43722_().m_41751_(tag);
        }
        if (!validAxis || playerEntity == null) {
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("FirstPulley")) {
            if (!BeltConnectorItem.canConnect(world, firstPulley, pos)) {
                return InteractionResult.FAIL;
            }
            if (firstPulley != null && !firstPulley.equals((Object)pos)) {
                BeltConnectorItem.createBelts(world, firstPulley, pos);
                AllAdvancements.BELT.awardTo(playerEntity);
                if (!playerEntity.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
            if (!context.m_43722_().m_41619_()) {
                context.m_43722_().m_41751_(null);
                playerEntity.m_36335_().m_41524_((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        tag.m_128365_("FirstPulley", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        context.m_43722_().m_41751_(tag);
        playerEntity.m_36335_().m_41524_((Item)this, 5);
        return InteractionResult.SUCCESS;
    }

    public static void createBelts(Level world, BlockPos start, BlockPos end) {
        world.m_5594_(null, new BlockPos(VecHelper.getCenterOf((Vec3i)start.m_141952_((Vec3i)end)).m_82490_(0.5)), SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
        BeltSlope slope = BeltConnectorItem.getSlopeBetween(start, end);
        Direction facing = BeltConnectorItem.getFacingFromTo(start, end);
        BlockPos diff = end.m_141950_((Vec3i)start);
        if (diff.m_123341_() == diff.m_123343_()) {
            facing = Direction.m_122390_((Direction.AxisDirection)facing.m_122421_(), (Direction.Axis)(world.m_8055_(start).m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        List<BlockPos> beltsToCreate = BeltConnectorItem.getBeltChainBetween(start, end, slope, facing);
        BlockState beltBlock = AllBlocks.BELT.getDefaultState();
        boolean failed = false;
        for (BlockPos pos : beltsToCreate) {
            BlockState existingBlock = world.m_8055_(pos);
            if (existingBlock.m_60800_((BlockGetter)world, pos) == -1.0f) {
                failed = true;
                break;
            }
            BeltPart part = pos.equals((Object)start) ? BeltPart.START : (pos.equals((Object)end) ? BeltPart.END : BeltPart.MIDDLE);
            BlockState shaftState = world.m_8055_(pos);
            boolean pulley = ShaftBlock.isShaft(shaftState);
            if (part == BeltPart.MIDDLE && pulley) {
                part = BeltPart.PULLEY;
            }
            if (pulley && shaftState.m_61143_((Property)AbstractSimpleShaftBlock.AXIS) == Direction.Axis.Y) {
                slope = BeltSlope.SIDEWAYS;
            }
            if (!existingBlock.m_60767_().m_76336_()) {
                world.m_46961_(pos, false);
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)((BlockState)((BlockState)beltBlock.m_61124_(BeltBlock.SLOPE, (Comparable)((Object)slope))).m_61124_(BeltBlock.PART, (Comparable)((Object)part))).m_61124_(BeltBlock.HORIZONTAL_FACING, (Comparable)facing));
        }
        if (!failed) {
            return;
        }
        for (BlockPos pos : beltsToCreate) {
            if (!AllBlocks.BELT.has(world.m_8055_(pos))) continue;
            world.m_46961_(pos, false);
        }
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.m_123341_() == end.m_123341_() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.m_141950_((Vec3i)start);
        Direction.AxisDirection axisDirection = Direction.AxisDirection.POSITIVE;
        axisDirection = diff.m_123341_() == 0 && diff.m_123343_() == 0 ? (diff.m_123342_() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE) : (beltAxis.m_7863_(diff.m_123341_(), 0, diff.m_123343_()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        return Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)beltAxis);
    }

    private static BeltSlope getSlopeBetween(BlockPos start, BlockPos end) {
        BlockPos diff = end.m_141950_((Vec3i)start);
        if (diff.m_123342_() != 0) {
            if (diff.m_123343_() != 0 || diff.m_123341_() != 0) {
                return diff.m_123342_() > 0 ? BeltSlope.UPWARD : BeltSlope.DOWNWARD;
            }
            return BeltSlope.VERTICAL;
        }
        return BeltSlope.HORIZONTAL;
    }

    private static List<BlockPos> getBeltChainBetween(BlockPos start, BlockPos end, BeltSlope slope, Direction direction) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        BlockPos current = start;
        do {
            positions.add(current);
            if (slope == BeltSlope.VERTICAL) {
                current = current.m_6630_(direction.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                continue;
            }
            current = current.m_142300_(direction);
            if (slope == BeltSlope.HORIZONTAL) continue;
            current = current.m_6630_(slope == BeltSlope.UPWARD ? 1 : -1);
        } while (!current.equals((Object)end) && limit-- > 0);
        positions.add(end);
        return positions;
    }

    public static boolean canConnect(Level world, BlockPos first, BlockPos second) {
        if (!world.m_46749_(first) || !world.m_46749_(second)) {
            return false;
        }
        if (!second.m_123314_((Vec3i)first, (double)BeltConnectorItem.maxLength().intValue())) {
            return false;
        }
        BlockPos diff = second.m_141950_((Vec3i)first);
        Direction.Axis shaftAxis = (Direction.Axis)world.m_8055_(first).m_61143_((Property)BlockStateProperties.f_61365_);
        int x = diff.m_123341_();
        int y = diff.m_123342_();
        int z = diff.m_123343_();
        int sames = (Math.abs(x) == Math.abs(y) ? 1 : 0) + (Math.abs(y) == Math.abs(z) ? 1 : 0) + (Math.abs(z) == Math.abs(x) ? 1 : 0);
        if (shaftAxis.m_7863_(x, y, z) != 0) {
            return false;
        }
        if (sames != 1) {
            return false;
        }
        if (shaftAxis != world.m_8055_(second).m_61143_((Property)BlockStateProperties.f_61365_)) {
            return false;
        }
        if (shaftAxis == Direction.Axis.Y && x != 0 && z != 0) {
            return false;
        }
        BlockEntity tileEntity = world.m_7702_(first);
        BlockEntity tileEntity2 = world.m_7702_(second);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return false;
        }
        if (!(tileEntity2 instanceof KineticTileEntity)) {
            return false;
        }
        float speed1 = ((KineticTileEntity)tileEntity).getTheoreticalSpeed();
        float speed2 = ((KineticTileEntity)tileEntity2).getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = new BlockPos((double)Math.signum(diff.m_123341_()), (double)Math.signum(diff.m_123342_()), (double)Math.signum(diff.m_123343_()));
        int limit = 1000;
        BlockPos currentPos = first.m_141952_((Vec3i)step);
        while (!currentPos.equals((Object)second) && limit-- > 0) {
            BlockState blockState = world.m_8055_(currentPos);
            if (!(ShaftBlock.isShaft(blockState) && blockState.m_61143_((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis || blockState.m_60767_().m_76336_())) {
                return false;
            }
            currentPos = currentPos.m_141952_((Vec3i)step);
        }
        return true;
    }

    public static Integer maxLength() {
        return (Integer)AllConfigs.SERVER.kinetics.maxBeltLength.get();
    }

    public static boolean validateAxis(Level world, BlockPos pos) {
        if (!world.m_46749_(pos)) {
            return false;
        }
        return ShaftBlock.isShaft(world.m_8055_(pos));
    }
}

