/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BlazeBurnerRenderer
extends SafeTileEntityRenderer<BlazeBurnerTileEntity> {
    public BlazeBurnerRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(BlazeBurnerTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = te.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        float horizontalAngle = AngleHelper.rad(te.headAngle.getValue(partialTicks));
        Level level = te.m_58904_();
        int hashCode = te.hashCode();
        float animation = te.headAnimation.getValue(partialTicks) * 0.175f;
        BlockState blockState = te.m_58900_();
        boolean drawGoggles = te.goggles;
        boolean drawHat = te.hat;
        BlazeBurnerRenderer.renderShared(level, buffer, null, ms, blockState, horizontalAngle, animation, drawGoggles, drawHat, hashCode);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer, LerpedFloat headAngle, boolean conductor) {
        BlockState state = context.state;
        if (BlazeBurnerBlock.getHeatLevelOf(state) == BlazeBurnerBlock.HeatLevel.KINDLED) {
            state = (BlockState)state.m_61124_(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.FADING));
        }
        float value = AngleHelper.rad(headAngle.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)context.world)));
        BlazeBurnerRenderer.renderShared(context.world, buffer, matrices.getModel(), matrices.getViewProjection(), state, value, 0.0f, context.tileData.m_128441_("Goggles"), conductor, context.hashCode());
    }

    private static void renderShared(Level level, MultiBufferSource buffer, @Nullable PoseStack modelTransform, PoseStack ms, BlockState blockState, float horizontalAngle, float animation, boolean drawGoggles, boolean drawHat, int hashCode) {
        PartialModel blazeModel;
        boolean blockAbove = animation > 0.125f;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf(blockState);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        VertexConsumer cutout = buffer.m_6299_(RenderType.m_110457_());
        ms.m_85836_();
        if (modelTransform == null && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && blockAbove) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().m_118410_() - spriteShift.getTarget().m_118409_();
            float spriteHeight = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            BlazeBurnerRenderer.draw(CachedBufferer.partial(AllBlockPartials.BLAZE_BURNER_FLAME, blockState).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll), horizontalAngle, modelTransform, ms, cutout);
        }
        PartialModel partialModel = blazeModel = modelTransform != null ? AllBlockPartials.BLAZE_IDLE : AllBlockPartials.BLAZE_INERT;
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            blazeModel = blockAbove ? AllBlockPartials.BLAZE_SUPER_ACTIVE : AllBlockPartials.BLAZE_SUPER;
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            blazeModel = blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllBlockPartials.BLAZE_ACTIVE : AllBlockPartials.BLAZE_IDLE;
        }
        float headY = offset - animation * 0.75f;
        BlazeBurnerRenderer.draw(CachedBufferer.partial(blazeModel, blockState).translate(0.0, headY, 0.0), horizontalAngle, modelTransform, ms, solid);
        if (drawGoggles) {
            BlazeBurnerRenderer.draw(CachedBufferer.partial(blazeModel == AllBlockPartials.BLAZE_INERT ? AllBlockPartials.BLAZE_GOGGLES_SMALL : AllBlockPartials.BLAZE_GOGGLES, blockState).translate(0.0, headY + 0.5f, 0.0), horizontalAngle, modelTransform, ms, solid);
        }
        if (drawHat) {
            SuperByteBuffer partial = CachedBufferer.partial(AllBlockPartials.TRAIN_HAT, blockState).translate(0.0, headY, 0.0);
            if (blazeModel == AllBlockPartials.BLAZE_INERT) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial.translateY(0.5)).centre()).scale(0.75f)).unCentre();
            } else {
                partial.translateY(0.75);
            }
            if (modelTransform != null) {
                partial.transform(modelTransform);
            }
            partial.rotateCentered(Direction.UP, horizontalAngle + (float)Math.PI).translate(0.5, 0.0, 0.5).light(0xF000F0).renderInto(ms, solid);
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) || modelTransform != null) {
            PartialModel rods = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS : AllBlockPartials.BLAZE_BURNER_RODS;
            PartialModel rods2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS_2 : AllBlockPartials.BLAZE_BURNER_RODS_2;
            BlazeBurnerRenderer.draw(CachedBufferer.partial(rods, blockState).translate(0.0, offset1 + animation + 0.125f, 0.0), 0.0f, modelTransform, ms, solid);
            BlazeBurnerRenderer.draw(CachedBufferer.partial(rods2, blockState).translate(0.0, offset2 + animation - 0.1875f, 0.0), 0.0f, modelTransform, ms, solid);
        }
        ms.m_85849_();
    }

    private static void draw(SuperByteBuffer blazeBuffer, float horizontalAngle, @Nullable PoseStack modelTransform, PoseStack ms, VertexConsumer vb) {
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.rotateCentered(Direction.UP, horizontalAngle).light(0xF000F0).renderInto(ms, vb);
    }
}

