/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineBlock;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleBlock;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BoilerData {
    static final int SAMPLE_RATE = 5;
    private static final int waterSupplyPerLevel = 10;
    private static final float passiveEngineEfficiency = 0.125f;
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;
    public boolean needsHeatLevelUpdate;
    public boolean passiveHeat;
    public int activeHeat;
    public float waterSupply;
    public int attachedEngines;
    public int attachedWhistles;
    private int maxHeatForSize = 0;
    private int maxHeatForWater = 0;
    private int minValue = 0;
    private int maxValue = 0;
    public LerpedFloat gauge = LerpedFloat.linear();

    public void tick(FluidTankTileEntity controller) {
        if (!this.isActive()) {
            return;
        }
        if (controller.m_58904_().f_46443_) {
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        int capacity = controller.tankInventory.getCapacity();
        if (capacity == 0) {
            return;
        }
        this.ticksUntilNextSample = 5;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 5.0f;
        this.waterSupply = Math.max(this.waterSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0;
        if (this.currentIndex == 0) {
            this.waterSupply = 0.0f;
            for (float i : this.supplyOverTime) {
                this.waterSupply = Math.max(i, this.waterSupply);
            }
        }
        if (controller instanceof CreativeFluidTankTileEntity) {
            this.waterSupply = 200.0f;
        }
        if (this.getActualHeat(controller.getTotalTankSize()) == 18) {
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);
        }
        controller.notifyUpdate();
    }

    public int getTheoreticalHeatLevel() {
        return this.activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int boilerSize) {
        return Math.min(18, boilerSize / 4);
    }

    public int getMaxHeatLevelForWaterSupply() {
        return Math.min(18, Mth.m_14167_((float)this.waterSupply) / 10);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        this.calcMinMaxForSize(boilerSize);
        return this.isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (this.isPassive(boilerSize)) {
            return 0.125f / (float)this.attachedEngines;
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(boilerSize);
        return this.attachedEngines <= actualHeat ? 1.0f : (float)actualHeat / (float)this.attachedEngines;
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        return actualHeat;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, int boilerSize) {
        if (!this.isActive()) {
            return false;
        }
        TextComponent indent = new TextComponent("    ");
        TextComponent indent2 = new TextComponent("     ");
        this.calcMinMaxForSize(boilerSize);
        tooltip.add((Component)indent.m_6879_().m_7220_((Component)Lang.translateDirect("boiler.status", this.getHeatLevelTextComponent().m_130940_(ChatFormatting.GREEN))));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getWaterComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        if (this.attachedEngines == 0) {
            return true;
        }
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        double totalSU = (double)(this.getEngineEfficiency(boilerSize) * 16.0f * (float)Math.max(boilerLevel, this.attachedEngines)) * BlockStressValues.getCapacity((Block)AllBlocks.STEAM_ENGINE.get());
        tooltip.add(Lang.empty());
        Lang.translate("tooltip.capacityProvided", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.number(totalSU).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add((this.attachedEngines == 1 ? Lang.translate("boiler.via_one_engine", new Object[0]) : Lang.translate("boiler.via_engines", this.attachedEngines)).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void calcMinMaxForSize(int boilerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        this.maxHeatForWater = this.getMaxHeatLevelForWaterSupply();
        this.minValue = Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForWater, this.maxHeatForSize));
    }

    @NotNull
    public MutableComponent getHeatLevelTextComponent() {
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        return this.isPassive() ? Lang.translateDirect("boiler.passive", new Object[0]) : (boilerLevel == 0 ? Lang.translateDirect("boiler.idle", new Object[0]) : (boilerLevel == 18 ? Lang.translateDirect("boiler.max_lvl", new Object[0]) : Lang.translateDirect("boiler.lvl", String.valueOf(boilerLevel))));
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("water", this.maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect("boiler." + label, new Object[0]).m_130940_(style1).m_7220_((Component)Lang.translateDirect("boiler." + label + "_dots", new Object[0]).m_130940_(style2)).m_7220_((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        return new TextComponent("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level));
    }

    private MutableComponent barComponent(int level) {
        return TextComponent.f_131282_.m_6881_().m_7220_((Component)this.bars(Math.max(0, this.minValue - 1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(this.minValue > 0 ? 1 : 0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(Math.max(0, level - this.minValue), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(Math.max(0, this.maxValue - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return new TextComponent(Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    public boolean evaluate(FluidTankTileEntity controller) {
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        int prevEngines = this.attachedEngines;
        int prevWhistles = this.attachedWhistles;
        this.attachedEngines = 0;
        this.attachedWhistles = 0;
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    BlockPos pos = controllerPos.m_142082_(xOffset, yOffset, zOffset);
                    BlockState blockState = level.m_8055_(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockPos attachedPos = pos.m_142300_(d);
                        BlockState attachedState = level.m_8055_(attachedPos);
                        if (AllBlocks.STEAM_ENGINE.has(attachedState) && SteamEngineBlock.getFacing(attachedState) == d) {
                            ++this.attachedEngines;
                        }
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection(attachedState).m_122424_() != d) continue;
                        ++this.attachedWhistles;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedEngines || prevWhistles != this.attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankTileEntity controller) {
        if (!controller.getBehaviour(AdvancementBehaviour.TYPE).isOwnerPresent()) {
            return;
        }
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        HashSet<Integer> whistlePitches = new HashSet<Integer>();
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    BlockPos pos = controllerPos.m_142082_(xOffset, yOffset, zOffset);
                    BlockState blockState = level.m_8055_(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockEntity blockEntity;
                        BlockPos attachedPos = pos.m_142300_(d);
                        BlockState attachedState = level.m_8055_(attachedPos);
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection(attachedState).m_122424_() != d || !((blockEntity = level.m_7702_(attachedPos)) instanceof WhistleTileEntity)) continue;
                        WhistleTileEntity wte = (WhistleTileEntity)blockEntity;
                        whistlePitches.add(wte.getPitchId());
                    }
                }
            }
        }
        if (whistlePitches.size() >= 12) {
            controller.award(AllAdvancements.PIPE_ORGAN);
        }
    }

    public boolean updateTemperature(FluidTankTileEntity controller) {
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                BlockState blockState;
                BlockPos pos = controllerPos.m_142082_(xOffset, -1, zOffset);
                float heat = BoilerHeaters.getActiveHeat(level, pos, blockState = level.m_8055_(pos));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public boolean isActive() {
        return this.attachedEngines > 0 || this.attachedWhistles > 0;
    }

    public void clear() {
        this.waterSupply = 0.0f;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedEngines = 0;
        Arrays.fill(this.supplyOverTime, 0.0f);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("Supply", this.waterSupply);
        nbt.m_128405_("ActiveHeat", this.activeHeat);
        nbt.m_128379_("PassiveHeat", this.passiveHeat);
        nbt.m_128405_("Engines", this.attachedEngines);
        nbt.m_128405_("Whistles", this.attachedWhistles);
        nbt.m_128379_("Update", this.needsHeatLevelUpdate);
        return nbt;
    }

    public void read(CompoundTag nbt, int boilerSize) {
        this.waterSupply = nbt.m_128457_("Supply");
        this.activeHeat = nbt.m_128451_("ActiveHeat");
        this.passiveHeat = nbt.m_128471_("PassiveHeat");
        this.attachedEngines = nbt.m_128451_("Engines");
        this.attachedWhistles = nbt.m_128451_("Whistles");
        this.needsHeatLevelUpdate = nbt.m_128471_("Update");
        Arrays.fill(this.supplyOverTime, (float)((int)this.waterSupply));
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = this.isPassive(boilerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase(target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 10000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return FluidHelper.isWater(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            int amount = resource.getAmount();
            if (action.execute()) {
                BoilerData.this.gatheredSupply += amount;
            }
            return amount;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

