/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.controls.ControlsServerHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ControlsInputPacket
extends SimplePacketBase {
    private Collection<Integer> activatedButtons;
    private boolean press;
    private int contraptionEntityId;
    private BlockPos controlsPos;
    private boolean stopControlling;

    public ControlsInputPacket(Collection<Integer> activatedButtons, boolean press, int contraptionEntityId, BlockPos controlsPos, boolean stopControlling) {
        this.contraptionEntityId = contraptionEntityId;
        this.activatedButtons = activatedButtons;
        this.press = press;
        this.controlsPos = controlsPos;
        this.stopControlling = stopControlling;
    }

    public ControlsInputPacket(FriendlyByteBuf buffer) {
        this.contraptionEntityId = buffer.readInt();
        this.activatedButtons = new ArrayList<Integer>();
        this.press = buffer.readBoolean();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.activatedButtons.add(buffer.m_130242_());
        }
        this.controlsPos = buffer.m_130135_();
        this.stopControlling = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.contraptionEntityId);
        buffer.writeBoolean(this.press);
        buffer.m_130130_(this.activatedButtons.size());
        this.activatedButtons.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
        buffer.m_130064_(this.controlsPos);
        buffer.writeBoolean(this.stopControlling);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Level world = player.m_20193_();
            UUID uniqueID = player.m_142081_();
            if (player.m_5833_() && this.press) {
                return;
            }
            Entity entity = world.m_6815_(this.contraptionEntityId);
            if (!(entity instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity ace = (AbstractContraptionEntity)entity;
            if (this.stopControlling) {
                ace.stopControlling(this.controlsPos);
                return;
            }
            if (ace.toGlobalVector(Vec3.m_82512_((Vec3i)this.controlsPos), 0.0f).m_82509_((Position)player.m_20182_(), 16.0)) {
                ControlsServerHandler.receivePressed((LevelAccessor)world, ace, this.controlsPos, uniqueID, this.activatedButtons, this.press);
            }
        });
        ctx.setPacketHandled(true);
    }
}

