/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class ContraptionWorld
extends WrappedWorld {
    final Contraption contraption;
    private final int minY;
    private final int height;

    public ContraptionWorld(Level world, Contraption contraption) {
        super(world);
        this.contraption = contraption;
        this.minY = ContraptionWorld.nextMultipleOf16(contraption.bounds.f_82289_ - 1.0);
        this.height = ContraptionWorld.nextMultipleOf16(contraption.bounds.f_82292_ + 1.0) - this.minY;
    }

    private static int nextMultipleOf16(double a) {
        return ((Math.abs((int)a) - 1 | 0xF) + 1) * Mth.m_14205_((double)a);
    }

    @Override
    public BlockState m_8055_(BlockPos pos) {
        StructureTemplate.StructureBlockInfo blockInfo = this.contraption.getBlocks().get(pos);
        if (blockInfo != null) {
            return blockInfo.f_74676_;
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public void m_6263_(Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        Vec3 worldPos = ContraptionCollider.getWorldToLocalTranslation(new Vec3(x, y, z), this.contraption.entity);
        worldPos = worldPos.m_82520_(x, y, z);
        this.world.m_6263_(player, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, soundIn, category, volume, pitch);
    }

    public void m_7785_(double x, double y, double z, SoundEvent p_184134_7_, SoundSource p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        this.world.m_7785_(x, y, z, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_11_);
    }

    public int m_141928_() {
        return this.height;
    }

    public int m_141937_() {
        return this.minY;
    }
}

