/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FlywheelRenderer
extends KineticTileEntityRenderer {
    public FlywheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState blockState = te.m_58900_();
        FlywheelTileEntity wte = (FlywheelTileEntity)te;
        float speed = wte.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = wte.angle + speed * partialTicks;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        this.renderFlywheel(te, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(KineticTileEntity te, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBufferer.block(blockState);
        FlywheelRenderer.kineticRotationTransform(wheel, te, FlywheelRenderer.getRotationAxisOf(te), AngleHelper.rad(angle), light);
        wheel.renderInto(ms, vb);
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return FlywheelRenderer.shaft(FlywheelRenderer.getRotationAxisOf(te));
    }
}

