/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
public class EncasedFanTileEntity
extends KineticTileEntity
implements IAirCurrentSource {
    public AirCurrent airCurrent = new AirCurrent(this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public EncasedFanTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.ENCASED_FAN, AllAdvancements.FAN_PROCESSING);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    @Override
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Override
    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    @Override
    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
    }

    @Override
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return (speed = EncasedFanTileEntity.convertToDirection(speed, facing)) > 0.0f ? facing : facing.m_122424_();
    }

    @Override
    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
        if (!direction.m_122434_().m_122478_()) {
            return;
        }
        BlockEntity poweredChute = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
        if (!(poweredChute instanceof ChuteTileEntity)) {
            return;
        }
        ChuteTileEntity chuteTE = (ChuteTileEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteTE.updatePull();
        } else {
            chuteTE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    @Override
    public void tick() {
        boolean server;
        super.tick();
        boolean bl = server = !this.f_58857_.f_46443_ || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            if (this.airCurrent.maxDistance > 0.0f) {
                this.award(AllAdvancements.ENCASED_FAN);
            }
            this.sendData();
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

