/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvesterActorInstance
extends ActorInstance {
    static double oneOverRadius = 2.4615384615384617;
    static float originOffset = 0.0625f;
    static Vec3 rotOffset = new Vec3(0.5, (double)(-2.0f * originOffset + 0.5f), (double)(originOffset + 0.5f));
    ModelData harvester;
    private Direction facing;
    private float horizontalAngle;
    private double rotation;
    private double previousRotation;

    public HarvesterActorInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        Material material = materialManager.defaultCutout().material(Materials.TRANSFORMED);
        BlockState state = context.state;
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.harvester = (ModelData)material.getModel(AllBlockPartials.HARVESTER_BLADE, state).createInstance();
        this.horizontalAngle = this.facing.m_122435_() + (float)(this.facing.m_122434_() == Direction.Axis.X ? 180 : 0);
        this.harvester.setBlockLight(this.localBlockLight());
    }

    @Override
    public void tick() {
        super.tick();
        this.previousRotation = this.rotation;
        if (this.context.contraption.stalled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.m_122424_())) {
            return;
        }
        double arcLength = this.context.motion.m_82553_();
        double radians = arcLength * oneOverRadius;
        float deg = AngleHelper.deg(radians);
        deg = (int)(deg * 3000.0f) / 3000;
        this.rotation += (double)deg * 1.25;
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.harvester.loadIdentity().translate((Vec3i)this.context.localPos)).centre()).rotateY((double)this.horizontalAngle)).unCentre()).translate(rotOffset)).rotateX(this.getRotation())).translateBack(rotOffset);
    }

    private double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }
}

