/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    private final AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory() {
        super(SpoutCategory.doubleItemIcon((ItemLike)AllBlocks.SPOUT.get(), (ItemLike)Items.f_42447_), SpoutCategory.emptyBackground(177, 70));
    }

    public static void consumeRecipes(Consumer<FillingRecipe> consumer, IIngredientManager ingredientManager) {
        Collection fluidStacks = ingredientManager.getAllIngredients(VanillaTypes.FLUID);
        for (ItemStack stack : ingredientManager.getAllIngredients(VanillaTypes.ITEM)) {
            if (stack.m_41720_() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient bottle = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_});
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput(stack).build());
                continue;
            }
            LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!capability.isPresent()) continue;
            for (FluidStack fluidStack : fluidStacks) {
                ItemStack copy = stack.m_41777_();
                copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fhi -> {
                    if (!GenericItemFilling.isFluidHandlerValid(copy, fhi)) {
                        return;
                    }
                    FluidStack fluidCopy = fluidStack.copy();
                    fluidCopy.setAmount(1000);
                    fhi.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = fhi.getContainer();
                    if (container.m_41656_(copy)) {
                        return;
                    }
                    if (container.m_41619_()) {
                        return;
                    }
                    Ingredient bucket = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                    ResourceLocation itemName = stack.m_41720_().getRegistryName();
                    ResourceLocation fluidName = fluidCopy.getFluid().getRegistryName();
                    consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.m_135827_() + "_" + itemName.m_135815_() + "_with_" + fluidName.m_135827_() + "_" + fluidName.m_135815_())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
                });
            }
        }
    }

    @Override
    public Class<? extends FillingRecipe> getRecipeClass() {
        return FillingRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 27, 32).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients(VanillaTypes.FLUID, SpoutCategory.withImprovedVisibility(recipe.getRequiredFluid().getMatchingFluidStacks()))).addTooltipCallback(SpoutCategory.addFluidTooltip(recipe.getRequiredFluid().getRequiredAmount()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.m_8043_());
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

