/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.jei.category.animations.AnimatedPress;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@ParametersAreNonnullByDefault
public class PackingCategory
extends BasinCategory {
    private final AnimatedPress press = new AnimatedPress(true);
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    private final PackingType type;

    public static PackingCategory standard() {
        return new PackingCategory(PackingType.COMPACTING, (ItemLike)AllBlocks.BASIN.get(), 103);
    }

    public static PackingCategory autoSquare() {
        return new PackingCategory(PackingType.AUTO_SQUARE, (ItemLike)Blocks.f_50091_, 85);
    }

    protected PackingCategory(PackingType type, ItemLike icon, int height) {
        super(type != PackingType.AUTO_SQUARE, PackingCategory.doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), icon), PackingCategory.emptyBackground(177, height));
        this.type = type;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BasinRecipe recipe, IFocusGroup focuses) {
        int rows;
        if (this.type == PackingType.COMPACTING) {
            super.setRecipe(builder, recipe, focuses);
            return;
        }
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int size = ingredients.size();
        int n = rows = size == 4 ? 2 : 3;
        for (int i = 0; i < size; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, (rows == 2 ? 27 : 18) + i % rows * 19, 51 - i / rows * 19).setBackground(PackingCategory.getRenderedSlot(), -1, -1).addIngredients(ingredient);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 51).setBackground(PackingCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.m_8043_());
    }

    @Override
    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        if (this.type == PackingType.COMPACTING) {
            super.draw(recipe, iRecipeSlotsView, matrixStack, mouseX, mouseY);
        } else {
            AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 136, 32);
            AllGuiTextures.JEI_SHADOW.render(matrixStack, 81, 68);
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(matrixStack, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.press.draw(matrixStack, this.getBackground().getWidth() / 2 + 3, 34);
    }

    static enum PackingType {
        AUTO_SQUARE,
        COMPACTING;

    }
}

